/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruRequest;
import software.amazon.awssdk.services.devopsguru.model.ListInsightsStatusFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInsightsRequest
extends DevOpsGuruRequest
implements ToCopyableBuilder<Builder, ListInsightsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListInsightsRequest.getter(ListInsightsRequest::maxResults)).setter(ListInsightsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInsightsRequest.getter(ListInsightsRequest::nextToken)).setter(ListInsightsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<ListInsightsStatusFilter> STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatusFilter").getter(ListInsightsRequest.getter(ListInsightsRequest::statusFilter)).setter(ListInsightsRequest.setter(Builder::statusFilter)).constructor(ListInsightsStatusFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, STATUS_FILTER_FIELD));
    private final Integer maxResults;
    private final String nextToken;
    private final ListInsightsStatusFilter statusFilter;

    private ListInsightsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.statusFilter = builder.statusFilter;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public ListInsightsStatusFilter statusFilter() {
        return this.statusFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusFilter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInsightsRequest)) {
            return false;
        }
        ListInsightsRequest other = (ListInsightsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.statusFilter(), other.statusFilter());
    }

    public String toString() {
        return ToString.builder((String)"ListInsightsRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("StatusFilter", (Object)this.statusFilter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "StatusFilter": {
                return Optional.ofNullable(clazz.cast(this.statusFilter()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInsightsRequest, T> g) {
        return obj -> g.apply((ListInsightsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private ListInsightsStatusFilter statusFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInsightsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.statusFilter(model.statusFilter);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final ListInsightsStatusFilter.Builder getStatusFilter() {
            return this.statusFilter != null ? this.statusFilter.toBuilder() : null;
        }

        @Override
        public final Builder statusFilter(ListInsightsStatusFilter statusFilter) {
            this.statusFilter = statusFilter;
            return this;
        }

        public final void setStatusFilter(ListInsightsStatusFilter.BuilderImpl statusFilter) {
            this.statusFilter = statusFilter != null ? statusFilter.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInsightsRequest build() {
            return new ListInsightsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DevOpsGuruRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInsightsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder statusFilter(ListInsightsStatusFilter var1);

        default public Builder statusFilter(Consumer<ListInsightsStatusFilter.Builder> statusFilter) {
            return this.statusFilter((ListInsightsStatusFilter)((ListInsightsStatusFilter.Builder)ListInsightsStatusFilter.builder().applyMutation(statusFilter)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

