/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.Counters;
import software.amazon.awssdk.services.devicefarm.model.Device;
import software.amazon.awssdk.services.devicefarm.model.DeviceMinutes;
import software.amazon.awssdk.services.devicefarm.model.ExecutionResult;
import software.amazon.awssdk.services.devicefarm.model.ExecutionStatus;
import software.amazon.awssdk.services.devicefarm.model.TestType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Job
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Job> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Job.getter(Job::arn)).setter(Job.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Job.getter(Job::name)).setter(Job.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Job.getter(Job::typeAsString)).setter(Job.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("created").getter(Job.getter(Job::created)).setter(Job.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Job.getter(Job::statusAsString)).setter(Job.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("result").getter(Job.getter(Job::resultAsString)).setter(Job.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()}).build();
    private static final SdkField<Instant> STARTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("started").getter(Job.getter(Job::started)).setter(Job.setter(Builder::started)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("started").build()}).build();
    private static final SdkField<Instant> STOPPED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("stopped").getter(Job.getter(Job::stopped)).setter(Job.setter(Builder::stopped)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopped").build()}).build();
    private static final SdkField<Counters> COUNTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("counters").getter(Job.getter(Job::counters)).setter(Job.setter(Builder::counters)).constructor(Counters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("counters").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(Job.getter(Job::message)).setter(Job.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Device> DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("device").getter(Job.getter(Job::device)).setter(Job.setter(Builder::device)).constructor(Device::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("device").build()}).build();
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceArn").getter(Job.getter(Job::instanceArn)).setter(Job.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()}).build();
    private static final SdkField<DeviceMinutes> DEVICE_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deviceMinutes").getter(Job.getter(Job::deviceMinutes)).setter(Job.setter(Builder::deviceMinutes)).constructor(DeviceMinutes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceMinutes").build()}).build();
    private static final SdkField<String> VIDEO_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("videoEndpoint").getter(Job.getter(Job::videoEndpoint)).setter(Job.setter(Builder::videoEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoEndpoint").build()}).build();
    private static final SdkField<Boolean> VIDEO_CAPTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("videoCapture").getter(Job.getter(Job::videoCapture)).setter(Job.setter(Builder::videoCapture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoCapture").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, TYPE_FIELD, CREATED_FIELD, STATUS_FIELD, RESULT_FIELD, STARTED_FIELD, STOPPED_FIELD, COUNTERS_FIELD, MESSAGE_FIELD, DEVICE_FIELD, INSTANCE_ARN_FIELD, DEVICE_MINUTES_FIELD, VIDEO_ENDPOINT_FIELD, VIDEO_CAPTURE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Job.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String type;
    private final Instant created;
    private final String status;
    private final String result;
    private final Instant started;
    private final Instant stopped;
    private final Counters counters;
    private final String message;
    private final Device device;
    private final String instanceArn;
    private final DeviceMinutes deviceMinutes;
    private final String videoEndpoint;
    private final Boolean videoCapture;

    private Job(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.created = builder.created;
        this.status = builder.status;
        this.result = builder.result;
        this.started = builder.started;
        this.stopped = builder.stopped;
        this.counters = builder.counters;
        this.message = builder.message;
        this.device = builder.device;
        this.instanceArn = builder.instanceArn;
        this.deviceMinutes = builder.deviceMinutes;
        this.videoEndpoint = builder.videoEndpoint;
        this.videoCapture = builder.videoCapture;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final TestType type() {
        return TestType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant created() {
        return this.created;
    }

    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ExecutionResult result() {
        return ExecutionResult.fromValue(this.result);
    }

    public final String resultAsString() {
        return this.result;
    }

    public final Instant started() {
        return this.started;
    }

    public final Instant stopped() {
        return this.stopped;
    }

    public final Counters counters() {
        return this.counters;
    }

    public final String message() {
        return this.message;
    }

    public final Device device() {
        return this.device;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final DeviceMinutes deviceMinutes() {
        return this.deviceMinutes;
    }

    public final String videoEndpoint() {
        return this.videoEndpoint;
    }

    public final Boolean videoCapture() {
        return this.videoCapture;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.started());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopped());
        hashCode = 31 * hashCode + Objects.hashCode(this.counters());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoCapture());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.resultAsString(), other.resultAsString()) && Objects.equals(this.started(), other.started()) && Objects.equals(this.stopped(), other.stopped()) && Objects.equals(this.counters(), other.counters()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.device(), other.device()) && Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.deviceMinutes(), other.deviceMinutes()) && Objects.equals(this.videoEndpoint(), other.videoEndpoint()) && Objects.equals(this.videoCapture(), other.videoCapture());
    }

    public final String toString() {
        return ToString.builder((String)"Job").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Created", (Object)this.created()).add("Status", (Object)this.statusAsString()).add("Result", (Object)this.resultAsString()).add("Started", (Object)this.started()).add("Stopped", (Object)this.stopped()).add("Counters", (Object)this.counters()).add("Message", (Object)this.message()).add("Device", (Object)this.device()).add("InstanceArn", (Object)this.instanceArn()).add("DeviceMinutes", (Object)this.deviceMinutes()).add("VideoEndpoint", (Object)this.videoEndpoint()).add("VideoCapture", (Object)this.videoCapture()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "result": {
                return Optional.ofNullable(clazz.cast(this.resultAsString()));
            }
            case "started": {
                return Optional.ofNullable(clazz.cast(this.started()));
            }
            case "stopped": {
                return Optional.ofNullable(clazz.cast(this.stopped()));
            }
            case "counters": {
                return Optional.ofNullable(clazz.cast(this.counters()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "device": {
                return Optional.ofNullable(clazz.cast(this.device()));
            }
            case "instanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "deviceMinutes": {
                return Optional.ofNullable(clazz.cast(this.deviceMinutes()));
            }
            case "videoEndpoint": {
                return Optional.ofNullable(clazz.cast(this.videoEndpoint()));
            }
            case "videoCapture": {
                return Optional.ofNullable(clazz.cast(this.videoCapture()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("created", CREATED_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("result", RESULT_FIELD);
        map.put("started", STARTED_FIELD);
        map.put("stopped", STOPPED_FIELD);
        map.put("counters", COUNTERS_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("device", DEVICE_FIELD);
        map.put("instanceArn", INSTANCE_ARN_FIELD);
        map.put("deviceMinutes", DEVICE_MINUTES_FIELD);
        map.put("videoEndpoint", VIDEO_ENDPOINT_FIELD);
        map.put("videoCapture", VIDEO_CAPTURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Job, T> g) {
        return obj -> g.apply((Job)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String type;
        private Instant created;
        private String status;
        private String result;
        private Instant started;
        private Instant stopped;
        private Counters counters;
        private String message;
        private Device device;
        private String instanceArn;
        private DeviceMinutes deviceMinutes;
        private String videoEndpoint;
        private Boolean videoCapture;

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            this.arn(model.arn);
            this.name(model.name);
            this.type(model.type);
            this.created(model.created);
            this.status(model.status);
            this.result(model.result);
            this.started(model.started);
            this.stopped(model.stopped);
            this.counters(model.counters);
            this.message(model.message);
            this.device(model.device);
            this.instanceArn(model.instanceArn);
            this.deviceMinutes(model.deviceMinutes);
            this.videoEndpoint(model.videoEndpoint);
            this.videoCapture(model.videoCapture);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getResult() {
            return this.result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final Instant getStarted() {
            return this.started;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final Instant getStopped() {
            return this.stopped;
        }

        public final void setStopped(Instant stopped) {
            this.stopped = stopped;
        }

        @Override
        public final Builder stopped(Instant stopped) {
            this.stopped = stopped;
            return this;
        }

        public final Counters.Builder getCounters() {
            return this.counters != null ? this.counters.toBuilder() : null;
        }

        public final void setCounters(Counters.BuilderImpl counters) {
            this.counters = counters != null ? counters.build() : null;
        }

        @Override
        public final Builder counters(Counters counters) {
            this.counters = counters;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Device.Builder getDevice() {
            return this.device != null ? this.device.toBuilder() : null;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final DeviceMinutes.Builder getDeviceMinutes() {
            return this.deviceMinutes != null ? this.deviceMinutes.toBuilder() : null;
        }

        public final void setDeviceMinutes(DeviceMinutes.BuilderImpl deviceMinutes) {
            this.deviceMinutes = deviceMinutes != null ? deviceMinutes.build() : null;
        }

        @Override
        public final Builder deviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
            return this;
        }

        public final String getVideoEndpoint() {
            return this.videoEndpoint;
        }

        public final void setVideoEndpoint(String videoEndpoint) {
            this.videoEndpoint = videoEndpoint;
        }

        @Override
        public final Builder videoEndpoint(String videoEndpoint) {
            this.videoEndpoint = videoEndpoint;
            return this;
        }

        public final Boolean getVideoCapture() {
            return this.videoCapture;
        }

        public final void setVideoCapture(Boolean videoCapture) {
            this.videoCapture = videoCapture;
        }

        @Override
        public final Builder videoCapture(Boolean videoCapture) {
            this.videoCapture = videoCapture;
            return this;
        }

        public Job build() {
            return new Job(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Job> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(TestType var1);

        public Builder created(Instant var1);

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder result(String var1);

        public Builder result(ExecutionResult var1);

        public Builder started(Instant var1);

        public Builder stopped(Instant var1);

        public Builder counters(Counters var1);

        default public Builder counters(Consumer<Counters.Builder> counters) {
            return this.counters((Counters)((Counters.Builder)Counters.builder().applyMutation(counters)).build());
        }

        public Builder message(String var1);

        public Builder device(Device var1);

        default public Builder device(Consumer<Device.Builder> device) {
            return this.device((Device)((Device.Builder)Device.builder().applyMutation(device)).build());
        }

        public Builder instanceArn(String var1);

        public Builder deviceMinutes(DeviceMinutes var1);

        default public Builder deviceMinutes(Consumer<DeviceMinutes.Builder> deviceMinutes) {
            return this.deviceMinutes((DeviceMinutes)((DeviceMinutes.Builder)DeviceMinutes.builder().applyMutation(deviceMinutes)).build());
        }

        public Builder videoEndpoint(String var1);

        public Builder videoCapture(Boolean var1);
    }
}

