/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.DevicePool;
import software.amazon.awssdk.services.devicefarm.model.DevicePoolsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDevicePoolsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListDevicePoolsResponse> {
    private static final SdkField<List<DevicePool>> DEVICE_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("devicePools").getter(ListDevicePoolsResponse.getter(ListDevicePoolsResponse::devicePools)).setter(ListDevicePoolsResponse.setter(Builder::devicePools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devicePools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DevicePool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDevicePoolsResponse.getter(ListDevicePoolsResponse::nextToken)).setter(ListDevicePoolsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_POOLS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("devicePools", DEVICE_POOLS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<DevicePool> devicePools;
    private final String nextToken;

    private ListDevicePoolsResponse(BuilderImpl builder) {
        super(builder);
        this.devicePools = builder.devicePools;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDevicePools() {
        return this.devicePools != null && !(this.devicePools instanceof SdkAutoConstructList);
    }

    public final List<DevicePool> devicePools() {
        return this.devicePools;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDevicePools() ? this.devicePools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicePoolsResponse)) {
            return false;
        }
        ListDevicePoolsResponse other = (ListDevicePoolsResponse)((Object)obj);
        return this.hasDevicePools() == other.hasDevicePools() && Objects.equals(this.devicePools(), other.devicePools()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDevicePoolsResponse").add("DevicePools", this.hasDevicePools() ? this.devicePools() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "devicePools": {
                return Optional.ofNullable(clazz.cast(this.devicePools()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDevicePoolsResponse, T> g) {
        return obj -> g.apply((ListDevicePoolsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<DevicePool> devicePools = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicePoolsResponse model) {
            super(model);
            this.devicePools(model.devicePools);
            this.nextToken(model.nextToken);
        }

        public final List<DevicePool.Builder> getDevicePools() {
            List<DevicePool.Builder> result = DevicePoolsCopier.copyToBuilder(this.devicePools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDevicePools(Collection<DevicePool.BuilderImpl> devicePools) {
            this.devicePools = DevicePoolsCopier.copyFromBuilder(devicePools);
        }

        @Override
        public final Builder devicePools(Collection<DevicePool> devicePools) {
            this.devicePools = DevicePoolsCopier.copy(devicePools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devicePools(DevicePool ... devicePools) {
            this.devicePools(Arrays.asList(devicePools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devicePools(Consumer<DevicePool.Builder> ... devicePools) {
            this.devicePools(Stream.of(devicePools).map(c -> (DevicePool)((DevicePool.Builder)DevicePool.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDevicePoolsResponse build() {
            return new ListDevicePoolsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDevicePoolsResponse> {
        public Builder devicePools(Collection<DevicePool> var1);

        public Builder devicePools(DevicePool ... var1);

        public Builder devicePools(Consumer<DevicePool.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

