/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.OfferingStatus;
import software.amazon.awssdk.services.devicefarm.model.OfferingStatusMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOfferingStatusResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, GetOfferingStatusResponse> {
    private static final SdkField<Map<String, OfferingStatus>> CURRENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("current").getter(GetOfferingStatusResponse.getter(GetOfferingStatusResponse::current)).setter(GetOfferingStatusResponse.setter(Builder::current)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("current").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OfferingStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, OfferingStatus>> NEXT_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("nextPeriod").getter(GetOfferingStatusResponse.getter(GetOfferingStatusResponse::nextPeriod)).setter(GetOfferingStatusResponse.setter(Builder::nextPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPeriod").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OfferingStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetOfferingStatusResponse.getter(GetOfferingStatusResponse::nextToken)).setter(GetOfferingStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_FIELD, NEXT_PERIOD_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("current", CURRENT_FIELD);
            this.put("nextPeriod", NEXT_PERIOD_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final Map<String, OfferingStatus> current;
    private final Map<String, OfferingStatus> nextPeriod;
    private final String nextToken;

    private GetOfferingStatusResponse(BuilderImpl builder) {
        super(builder);
        this.current = builder.current;
        this.nextPeriod = builder.nextPeriod;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCurrent() {
        return this.current != null && !(this.current instanceof SdkAutoConstructMap);
    }

    public final Map<String, OfferingStatus> current() {
        return this.current;
    }

    public final boolean hasNextPeriod() {
        return this.nextPeriod != null && !(this.nextPeriod instanceof SdkAutoConstructMap);
    }

    public final Map<String, OfferingStatus> nextPeriod() {
        return this.nextPeriod;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCurrent() ? this.current() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNextPeriod() ? this.nextPeriod() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOfferingStatusResponse)) {
            return false;
        }
        GetOfferingStatusResponse other = (GetOfferingStatusResponse)((Object)obj);
        return this.hasCurrent() == other.hasCurrent() && Objects.equals(this.current(), other.current()) && this.hasNextPeriod() == other.hasNextPeriod() && Objects.equals(this.nextPeriod(), other.nextPeriod()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetOfferingStatusResponse").add("Current", this.hasCurrent() ? this.current() : null).add("NextPeriod", this.hasNextPeriod() ? this.nextPeriod() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "current": {
                return Optional.ofNullable(clazz.cast(this.current()));
            }
            case "nextPeriod": {
                return Optional.ofNullable(clazz.cast(this.nextPeriod()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetOfferingStatusResponse, T> g) {
        return obj -> g.apply((GetOfferingStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private Map<String, OfferingStatus> current = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, OfferingStatus> nextPeriod = DefaultSdkAutoConstructMap.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOfferingStatusResponse model) {
            super(model);
            this.current(model.current);
            this.nextPeriod(model.nextPeriod);
            this.nextToken(model.nextToken);
        }

        public final Map<String, OfferingStatus.Builder> getCurrent() {
            Map<String, OfferingStatus.Builder> result = OfferingStatusMapCopier.copyToBuilder(this.current);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCurrent(Map<String, OfferingStatus.BuilderImpl> current) {
            this.current = OfferingStatusMapCopier.copyFromBuilder(current);
        }

        @Override
        public final Builder current(Map<String, OfferingStatus> current) {
            this.current = OfferingStatusMapCopier.copy(current);
            return this;
        }

        public final Map<String, OfferingStatus.Builder> getNextPeriod() {
            Map<String, OfferingStatus.Builder> result = OfferingStatusMapCopier.copyToBuilder(this.nextPeriod);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setNextPeriod(Map<String, OfferingStatus.BuilderImpl> nextPeriod) {
            this.nextPeriod = OfferingStatusMapCopier.copyFromBuilder(nextPeriod);
        }

        @Override
        public final Builder nextPeriod(Map<String, OfferingStatus> nextPeriod) {
            this.nextPeriod = OfferingStatusMapCopier.copy(nextPeriod);
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetOfferingStatusResponse build() {
            return new GetOfferingStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOfferingStatusResponse> {
        public Builder current(Map<String, OfferingStatus> var1);

        public Builder nextPeriod(Map<String, OfferingStatus> var1);

        public Builder nextToken(String var1);
    }
}

