/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.services.devicefarm.model.DeviceSelectionConfiguration;
import software.amazon.awssdk.services.devicefarm.model.ExecutionConfiguration;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunConfiguration;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunTest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduleRunRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, ScheduleRunRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectArn").getter(ScheduleRunRequest.getter(ScheduleRunRequest::projectArn)).setter(ScheduleRunRequest.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()}).build();
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(ScheduleRunRequest.getter(ScheduleRunRequest::appArn)).setter(ScheduleRunRequest.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> DEVICE_POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("devicePoolArn").getter(ScheduleRunRequest.getter(ScheduleRunRequest::devicePoolArn)).setter(ScheduleRunRequest.setter(Builder::devicePoolArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devicePoolArn").build()}).build();
    private static final SdkField<DeviceSelectionConfiguration> DEVICE_SELECTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deviceSelectionConfiguration").getter(ScheduleRunRequest.getter(ScheduleRunRequest::deviceSelectionConfiguration)).setter(ScheduleRunRequest.setter(Builder::deviceSelectionConfiguration)).constructor(DeviceSelectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceSelectionConfiguration").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ScheduleRunRequest.getter(ScheduleRunRequest::name)).setter(ScheduleRunRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ScheduleRunTest> TEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("test").getter(ScheduleRunRequest.getter(ScheduleRunRequest::test)).setter(ScheduleRunRequest.setter(Builder::test)).constructor(ScheduleRunTest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("test").build()}).build();
    private static final SdkField<ScheduleRunConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(ScheduleRunRequest.getter(ScheduleRunRequest::configuration)).setter(ScheduleRunRequest.setter(Builder::configuration)).constructor(ScheduleRunConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<ExecutionConfiguration> EXECUTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("executionConfiguration").getter(ScheduleRunRequest.getter(ScheduleRunRequest::executionConfiguration)).setter(ScheduleRunRequest.setter(Builder::executionConfiguration)).constructor(ExecutionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, APP_ARN_FIELD, DEVICE_POOL_ARN_FIELD, DEVICE_SELECTION_CONFIGURATION_FIELD, NAME_FIELD, TEST_FIELD, CONFIGURATION_FIELD, EXECUTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("projectArn", PROJECT_ARN_FIELD);
            this.put("appArn", APP_ARN_FIELD);
            this.put("devicePoolArn", DEVICE_POOL_ARN_FIELD);
            this.put("deviceSelectionConfiguration", DEVICE_SELECTION_CONFIGURATION_FIELD);
            this.put("name", NAME_FIELD);
            this.put("test", TEST_FIELD);
            this.put("configuration", CONFIGURATION_FIELD);
            this.put("executionConfiguration", EXECUTION_CONFIGURATION_FIELD);
        }
    });
    private final String projectArn;
    private final String appArn;
    private final String devicePoolArn;
    private final DeviceSelectionConfiguration deviceSelectionConfiguration;
    private final String name;
    private final ScheduleRunTest test;
    private final ScheduleRunConfiguration configuration;
    private final ExecutionConfiguration executionConfiguration;

    private ScheduleRunRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.appArn = builder.appArn;
        this.devicePoolArn = builder.devicePoolArn;
        this.deviceSelectionConfiguration = builder.deviceSelectionConfiguration;
        this.name = builder.name;
        this.test = builder.test;
        this.configuration = builder.configuration;
        this.executionConfiguration = builder.executionConfiguration;
    }

    public final String projectArn() {
        return this.projectArn;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String devicePoolArn() {
        return this.devicePoolArn;
    }

    public final DeviceSelectionConfiguration deviceSelectionConfiguration() {
        return this.deviceSelectionConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final ScheduleRunTest test() {
        return this.test;
    }

    public final ScheduleRunConfiguration configuration() {
        return this.configuration;
    }

    public final ExecutionConfiguration executionConfiguration() {
        return this.executionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.devicePoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceSelectionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.test());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleRunRequest)) {
            return false;
        }
        ScheduleRunRequest other = (ScheduleRunRequest)((Object)obj);
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.devicePoolArn(), other.devicePoolArn()) && Objects.equals(this.deviceSelectionConfiguration(), other.deviceSelectionConfiguration()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.test(), other.test()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.executionConfiguration(), other.executionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduleRunRequest").add("ProjectArn", (Object)this.projectArn()).add("AppArn", (Object)this.appArn()).add("DevicePoolArn", (Object)this.devicePoolArn()).add("DeviceSelectionConfiguration", (Object)this.deviceSelectionConfiguration()).add("Name", (Object)this.name()).add("Test", (Object)this.test()).add("Configuration", (Object)this.configuration()).add("ExecutionConfiguration", (Object)this.executionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "devicePoolArn": {
                return Optional.ofNullable(clazz.cast(this.devicePoolArn()));
            }
            case "deviceSelectionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deviceSelectionConfiguration()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "test": {
                return Optional.ofNullable(clazz.cast(this.test()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "executionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.executionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleRunRequest, T> g) {
        return obj -> g.apply((ScheduleRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String projectArn;
        private String appArn;
        private String devicePoolArn;
        private DeviceSelectionConfiguration deviceSelectionConfiguration;
        private String name;
        private ScheduleRunTest test;
        private ScheduleRunConfiguration configuration;
        private ExecutionConfiguration executionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleRunRequest model) {
            super(model);
            this.projectArn(model.projectArn);
            this.appArn(model.appArn);
            this.devicePoolArn(model.devicePoolArn);
            this.deviceSelectionConfiguration(model.deviceSelectionConfiguration);
            this.name(model.name);
            this.test(model.test);
            this.configuration(model.configuration);
            this.executionConfiguration(model.executionConfiguration);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getDevicePoolArn() {
            return this.devicePoolArn;
        }

        public final void setDevicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
        }

        @Override
        public final Builder devicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
            return this;
        }

        public final DeviceSelectionConfiguration.Builder getDeviceSelectionConfiguration() {
            return this.deviceSelectionConfiguration != null ? this.deviceSelectionConfiguration.toBuilder() : null;
        }

        public final void setDeviceSelectionConfiguration(DeviceSelectionConfiguration.BuilderImpl deviceSelectionConfiguration) {
            this.deviceSelectionConfiguration = deviceSelectionConfiguration != null ? deviceSelectionConfiguration.build() : null;
        }

        @Override
        public final Builder deviceSelectionConfiguration(DeviceSelectionConfiguration deviceSelectionConfiguration) {
            this.deviceSelectionConfiguration = deviceSelectionConfiguration;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ScheduleRunTest.Builder getTest() {
            return this.test != null ? this.test.toBuilder() : null;
        }

        public final void setTest(ScheduleRunTest.BuilderImpl test) {
            this.test = test != null ? test.build() : null;
        }

        @Override
        public final Builder test(ScheduleRunTest test) {
            this.test = test;
            return this;
        }

        public final ScheduleRunConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(ScheduleRunConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ScheduleRunConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final ExecutionConfiguration.Builder getExecutionConfiguration() {
            return this.executionConfiguration != null ? this.executionConfiguration.toBuilder() : null;
        }

        public final void setExecutionConfiguration(ExecutionConfiguration.BuilderImpl executionConfiguration) {
            this.executionConfiguration = executionConfiguration != null ? executionConfiguration.build() : null;
        }

        @Override
        public final Builder executionConfiguration(ExecutionConfiguration executionConfiguration) {
            this.executionConfiguration = executionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ScheduleRunRequest build() {
            return new ScheduleRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeviceFarmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ScheduleRunRequest> {
        public Builder projectArn(String var1);

        public Builder appArn(String var1);

        public Builder devicePoolArn(String var1);

        public Builder deviceSelectionConfiguration(DeviceSelectionConfiguration var1);

        default public Builder deviceSelectionConfiguration(Consumer<DeviceSelectionConfiguration.Builder> deviceSelectionConfiguration) {
            return this.deviceSelectionConfiguration((DeviceSelectionConfiguration)((DeviceSelectionConfiguration.Builder)DeviceSelectionConfiguration.builder().applyMutation(deviceSelectionConfiguration)).build());
        }

        public Builder name(String var1);

        public Builder test(ScheduleRunTest var1);

        default public Builder test(Consumer<ScheduleRunTest.Builder> test) {
            return this.test((ScheduleRunTest)((ScheduleRunTest.Builder)ScheduleRunTest.builder().applyMutation(test)).build());
        }

        public Builder configuration(ScheduleRunConfiguration var1);

        default public Builder configuration(Consumer<ScheduleRunConfiguration.Builder> configuration) {
            return this.configuration((ScheduleRunConfiguration)((ScheduleRunConfiguration.Builder)ScheduleRunConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder executionConfiguration(ExecutionConfiguration var1);

        default public Builder executionConfiguration(Consumer<ExecutionConfiguration.Builder> executionConfiguration) {
            return this.executionConfiguration((ExecutionConfiguration)((ExecutionConfiguration.Builder)ExecutionConfiguration.builder().applyMutation(executionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

