/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Location
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Location> {
    private static final SdkField<Double> LATITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("latitude").getter(Location.getter(Location::latitude)).setter(Location.setter(Builder::latitude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latitude").build()}).build();
    private static final SdkField<Double> LONGITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("longitude").getter(Location.getter(Location::longitude)).setter(Location.setter(Builder::longitude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longitude").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATITUDE_FIELD, LONGITUDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("latitude", LATITUDE_FIELD);
            this.put("longitude", LONGITUDE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Double latitude;
    private final Double longitude;

    private Location(BuilderImpl builder) {
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
    }

    public final Double latitude() {
        return this.latitude;
    }

    public final Double longitude() {
        return this.longitude;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.latitude());
        hashCode = 31 * hashCode + Objects.hashCode(this.longitude());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        return Objects.equals(this.latitude(), other.latitude()) && Objects.equals(this.longitude(), other.longitude());
    }

    public final String toString() {
        return ToString.builder((String)"Location").add("Latitude", (Object)this.latitude()).add("Longitude", (Object)this.longitude()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "latitude": {
                return Optional.ofNullable(clazz.cast(this.latitude()));
            }
            case "longitude": {
                return Optional.ofNullable(clazz.cast(this.longitude()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Location, T> g) {
        return obj -> g.apply((Location)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double latitude;
        private Double longitude;

        private BuilderImpl() {
        }

        private BuilderImpl(Location model) {
            this.latitude(model.latitude);
            this.longitude(model.longitude);
        }

        public final Double getLatitude() {
            return this.latitude;
        }

        public final void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        @Override
        public final Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public final Double getLongitude() {
            return this.longitude;
        }

        public final void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        @Override
        public final Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Location build() {
            return new Location(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Location> {
        public Builder latitude(Double var1);

        public Builder longitude(Double var1);
    }
}

