/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.devicefarm.DefaultDeviceFarmBaseClientBuilder;
import software.amazon.awssdk.services.devicefarm.DefaultDeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClientBuilder;
import software.amazon.awssdk.services.devicefarm.DeviceFarmServiceClientConfiguration;
import software.amazon.awssdk.services.devicefarm.endpoints.DeviceFarmEndpointProvider;

@SdkInternalApi
final class DefaultDeviceFarmClientBuilder
extends DefaultDeviceFarmBaseClientBuilder<DeviceFarmClientBuilder, DeviceFarmClient>
implements DeviceFarmClientBuilder {
    DefaultDeviceFarmClientBuilder() {
    }

    @Override
    public DefaultDeviceFarmClientBuilder endpointProvider(DeviceFarmEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DeviceFarmClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDeviceFarmClientBuilder.validateClientOptions(clientConfiguration);
        DeviceFarmServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDeviceFarmClient client = new DefaultDeviceFarmClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DeviceFarmServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DeviceFarmServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

