/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridProjectsResponse;

public class ListTestGridProjectsIterable
implements SdkIterable<ListTestGridProjectsResponse> {
    private final DeviceFarmClient client;
    private final ListTestGridProjectsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestGridProjectsIterable(DeviceFarmClient client, ListTestGridProjectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTestGridProjectsResponseFetcher();
    }

    public Iterator<ListTestGridProjectsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTestGridProjectsResponseFetcher
    implements SyncPageFetcher<ListTestGridProjectsResponse> {
        private ListTestGridProjectsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestGridProjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTestGridProjectsResponse nextPage(ListTestGridProjectsResponse previousPage) {
            if (previousPage == null) {
                return ListTestGridProjectsIterable.this.client.listTestGridProjects(ListTestGridProjectsIterable.this.firstRequest);
            }
            return ListTestGridProjectsIterable.this.client.listTestGridProjects((ListTestGridProjectsRequest)((Object)ListTestGridProjectsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

