/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.BillingMethod;
import software.amazon.awssdk.services.devicefarm.model.Counters;
import software.amazon.awssdk.services.devicefarm.model.CustomerArtifactPaths;
import software.amazon.awssdk.services.devicefarm.model.DeviceMinutes;
import software.amazon.awssdk.services.devicefarm.model.DevicePlatform;
import software.amazon.awssdk.services.devicefarm.model.DeviceSelectionResult;
import software.amazon.awssdk.services.devicefarm.model.ExecutionResult;
import software.amazon.awssdk.services.devicefarm.model.ExecutionResultCode;
import software.amazon.awssdk.services.devicefarm.model.ExecutionStatus;
import software.amazon.awssdk.services.devicefarm.model.Location;
import software.amazon.awssdk.services.devicefarm.model.NetworkProfile;
import software.amazon.awssdk.services.devicefarm.model.Radios;
import software.amazon.awssdk.services.devicefarm.model.TestType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Run
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Run> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Run.getter(Run::arn)).setter(Run.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Run.getter(Run::name)).setter(Run.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Run.getter(Run::typeAsString)).setter(Run.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(Run.getter(Run::platformAsString)).setter(Run.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("created").getter(Run.getter(Run::created)).setter(Run.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Run.getter(Run::statusAsString)).setter(Run.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("result").getter(Run.getter(Run::resultAsString)).setter(Run.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()}).build();
    private static final SdkField<Instant> STARTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("started").getter(Run.getter(Run::started)).setter(Run.setter(Builder::started)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("started").build()}).build();
    private static final SdkField<Instant> STOPPED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("stopped").getter(Run.getter(Run::stopped)).setter(Run.setter(Builder::stopped)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopped").build()}).build();
    private static final SdkField<Counters> COUNTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("counters").getter(Run.getter(Run::counters)).setter(Run.setter(Builder::counters)).constructor(Counters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("counters").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(Run.getter(Run::message)).setter(Run.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Integer> TOTAL_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalJobs").getter(Run.getter(Run::totalJobs)).setter(Run.setter(Builder::totalJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalJobs").build()}).build();
    private static final SdkField<Integer> COMPLETED_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("completedJobs").getter(Run.getter(Run::completedJobs)).setter(Run.setter(Builder::completedJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedJobs").build()}).build();
    private static final SdkField<String> BILLING_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("billingMethod").getter(Run.getter(Run::billingMethodAsString)).setter(Run.setter(Builder::billingMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingMethod").build()}).build();
    private static final SdkField<DeviceMinutes> DEVICE_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deviceMinutes").getter(Run.getter(Run::deviceMinutes)).setter(Run.setter(Builder::deviceMinutes)).constructor(DeviceMinutes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceMinutes").build()}).build();
    private static final SdkField<NetworkProfile> NETWORK_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkProfile").getter(Run.getter(Run::networkProfile)).setter(Run.setter(Builder::networkProfile)).constructor(NetworkProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkProfile").build()}).build();
    private static final SdkField<String> PARSING_RESULT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parsingResultUrl").getter(Run.getter(Run::parsingResultUrl)).setter(Run.setter(Builder::parsingResultUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parsingResultUrl").build()}).build();
    private static final SdkField<String> RESULT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resultCode").getter(Run.getter(Run::resultCodeAsString)).setter(Run.setter(Builder::resultCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultCode").build()}).build();
    private static final SdkField<Integer> SEED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("seed").getter(Run.getter(Run::seed)).setter(Run.setter(Builder::seed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seed").build()}).build();
    private static final SdkField<String> APP_UPLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appUpload").getter(Run.getter(Run::appUpload)).setter(Run.setter(Builder::appUpload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appUpload").build()}).build();
    private static final SdkField<Integer> EVENT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("eventCount").getter(Run.getter(Run::eventCount)).setter(Run.setter(Builder::eventCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventCount").build()}).build();
    private static final SdkField<Integer> JOB_TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("jobTimeoutMinutes").getter(Run.getter(Run::jobTimeoutMinutes)).setter(Run.setter(Builder::jobTimeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTimeoutMinutes").build()}).build();
    private static final SdkField<String> DEVICE_POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("devicePoolArn").getter(Run.getter(Run::devicePoolArn)).setter(Run.setter(Builder::devicePoolArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devicePoolArn").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locale").getter(Run.getter(Run::locale)).setter(Run.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()}).build();
    private static final SdkField<Radios> RADIOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("radios").getter(Run.getter(Run::radios)).setter(Run.setter(Builder::radios)).constructor(Radios::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("radios").build()}).build();
    private static final SdkField<Location> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(Run.getter(Run::location)).setter(Run.setter(Builder::location)).constructor(Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<CustomerArtifactPaths> CUSTOMER_ARTIFACT_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customerArtifactPaths").getter(Run.getter(Run::customerArtifactPaths)).setter(Run.setter(Builder::customerArtifactPaths)).constructor(CustomerArtifactPaths::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerArtifactPaths").build()}).build();
    private static final SdkField<String> WEB_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("webUrl").getter(Run.getter(Run::webUrl)).setter(Run.setter(Builder::webUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webUrl").build()}).build();
    private static final SdkField<Boolean> SKIP_APP_RESIGN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("skipAppResign").getter(Run.getter(Run::skipAppResign)).setter(Run.setter(Builder::skipAppResign)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skipAppResign").build()}).build();
    private static final SdkField<String> TEST_SPEC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSpecArn").getter(Run.getter(Run::testSpecArn)).setter(Run.setter(Builder::testSpecArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSpecArn").build()}).build();
    private static final SdkField<DeviceSelectionResult> DEVICE_SELECTION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deviceSelectionResult").getter(Run.getter(Run::deviceSelectionResult)).setter(Run.setter(Builder::deviceSelectionResult)).constructor(DeviceSelectionResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceSelectionResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, TYPE_FIELD, PLATFORM_FIELD, CREATED_FIELD, STATUS_FIELD, RESULT_FIELD, STARTED_FIELD, STOPPED_FIELD, COUNTERS_FIELD, MESSAGE_FIELD, TOTAL_JOBS_FIELD, COMPLETED_JOBS_FIELD, BILLING_METHOD_FIELD, DEVICE_MINUTES_FIELD, NETWORK_PROFILE_FIELD, PARSING_RESULT_URL_FIELD, RESULT_CODE_FIELD, SEED_FIELD, APP_UPLOAD_FIELD, EVENT_COUNT_FIELD, JOB_TIMEOUT_MINUTES_FIELD, DEVICE_POOL_ARN_FIELD, LOCALE_FIELD, RADIOS_FIELD, LOCATION_FIELD, CUSTOMER_ARTIFACT_PATHS_FIELD, WEB_URL_FIELD, SKIP_APP_RESIGN_FIELD, TEST_SPEC_ARN_FIELD, DEVICE_SELECTION_RESULT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String type;
    private final String platform;
    private final Instant created;
    private final String status;
    private final String result;
    private final Instant started;
    private final Instant stopped;
    private final Counters counters;
    private final String message;
    private final Integer totalJobs;
    private final Integer completedJobs;
    private final String billingMethod;
    private final DeviceMinutes deviceMinutes;
    private final NetworkProfile networkProfile;
    private final String parsingResultUrl;
    private final String resultCode;
    private final Integer seed;
    private final String appUpload;
    private final Integer eventCount;
    private final Integer jobTimeoutMinutes;
    private final String devicePoolArn;
    private final String locale;
    private final Radios radios;
    private final Location location;
    private final CustomerArtifactPaths customerArtifactPaths;
    private final String webUrl;
    private final Boolean skipAppResign;
    private final String testSpecArn;
    private final DeviceSelectionResult deviceSelectionResult;

    private Run(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.platform = builder.platform;
        this.created = builder.created;
        this.status = builder.status;
        this.result = builder.result;
        this.started = builder.started;
        this.stopped = builder.stopped;
        this.counters = builder.counters;
        this.message = builder.message;
        this.totalJobs = builder.totalJobs;
        this.completedJobs = builder.completedJobs;
        this.billingMethod = builder.billingMethod;
        this.deviceMinutes = builder.deviceMinutes;
        this.networkProfile = builder.networkProfile;
        this.parsingResultUrl = builder.parsingResultUrl;
        this.resultCode = builder.resultCode;
        this.seed = builder.seed;
        this.appUpload = builder.appUpload;
        this.eventCount = builder.eventCount;
        this.jobTimeoutMinutes = builder.jobTimeoutMinutes;
        this.devicePoolArn = builder.devicePoolArn;
        this.locale = builder.locale;
        this.radios = builder.radios;
        this.location = builder.location;
        this.customerArtifactPaths = builder.customerArtifactPaths;
        this.webUrl = builder.webUrl;
        this.skipAppResign = builder.skipAppResign;
        this.testSpecArn = builder.testSpecArn;
        this.deviceSelectionResult = builder.deviceSelectionResult;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final TestType type() {
        return TestType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final DevicePlatform platform() {
        return DevicePlatform.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final Instant created() {
        return this.created;
    }

    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ExecutionResult result() {
        return ExecutionResult.fromValue(this.result);
    }

    public final String resultAsString() {
        return this.result;
    }

    public final Instant started() {
        return this.started;
    }

    public final Instant stopped() {
        return this.stopped;
    }

    public final Counters counters() {
        return this.counters;
    }

    public final String message() {
        return this.message;
    }

    public final Integer totalJobs() {
        return this.totalJobs;
    }

    public final Integer completedJobs() {
        return this.completedJobs;
    }

    public final BillingMethod billingMethod() {
        return BillingMethod.fromValue(this.billingMethod);
    }

    public final String billingMethodAsString() {
        return this.billingMethod;
    }

    public final DeviceMinutes deviceMinutes() {
        return this.deviceMinutes;
    }

    public final NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public final String parsingResultUrl() {
        return this.parsingResultUrl;
    }

    public final ExecutionResultCode resultCode() {
        return ExecutionResultCode.fromValue(this.resultCode);
    }

    public final String resultCodeAsString() {
        return this.resultCode;
    }

    public final Integer seed() {
        return this.seed;
    }

    public final String appUpload() {
        return this.appUpload;
    }

    public final Integer eventCount() {
        return this.eventCount;
    }

    public final Integer jobTimeoutMinutes() {
        return this.jobTimeoutMinutes;
    }

    public final String devicePoolArn() {
        return this.devicePoolArn;
    }

    public final String locale() {
        return this.locale;
    }

    public final Radios radios() {
        return this.radios;
    }

    public final Location location() {
        return this.location;
    }

    public final CustomerArtifactPaths customerArtifactPaths() {
        return this.customerArtifactPaths;
    }

    public final String webUrl() {
        return this.webUrl;
    }

    public final Boolean skipAppResign() {
        return this.skipAppResign;
    }

    public final String testSpecArn() {
        return this.testSpecArn;
    }

    public final DeviceSelectionResult deviceSelectionResult() {
        return this.deviceSelectionResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.started());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopped());
        hashCode = 31 * hashCode + Objects.hashCode(this.counters());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.parsingResultUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.seed());
        hashCode = 31 * hashCode + Objects.hashCode(this.appUpload());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTimeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.devicePoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.radios());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerArtifactPaths());
        hashCode = 31 * hashCode + Objects.hashCode(this.webUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipAppResign());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSpecArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceSelectionResult());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Run)) {
            return false;
        }
        Run other = (Run)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.resultAsString(), other.resultAsString()) && Objects.equals(this.started(), other.started()) && Objects.equals(this.stopped(), other.stopped()) && Objects.equals(this.counters(), other.counters()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.totalJobs(), other.totalJobs()) && Objects.equals(this.completedJobs(), other.completedJobs()) && Objects.equals(this.billingMethodAsString(), other.billingMethodAsString()) && Objects.equals(this.deviceMinutes(), other.deviceMinutes()) && Objects.equals(this.networkProfile(), other.networkProfile()) && Objects.equals(this.parsingResultUrl(), other.parsingResultUrl()) && Objects.equals(this.resultCodeAsString(), other.resultCodeAsString()) && Objects.equals(this.seed(), other.seed()) && Objects.equals(this.appUpload(), other.appUpload()) && Objects.equals(this.eventCount(), other.eventCount()) && Objects.equals(this.jobTimeoutMinutes(), other.jobTimeoutMinutes()) && Objects.equals(this.devicePoolArn(), other.devicePoolArn()) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.radios(), other.radios()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.customerArtifactPaths(), other.customerArtifactPaths()) && Objects.equals(this.webUrl(), other.webUrl()) && Objects.equals(this.skipAppResign(), other.skipAppResign()) && Objects.equals(this.testSpecArn(), other.testSpecArn()) && Objects.equals(this.deviceSelectionResult(), other.deviceSelectionResult());
    }

    public final String toString() {
        return ToString.builder((String)"Run").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Platform", (Object)this.platformAsString()).add("Created", (Object)this.created()).add("Status", (Object)this.statusAsString()).add("Result", (Object)this.resultAsString()).add("Started", (Object)this.started()).add("Stopped", (Object)this.stopped()).add("Counters", (Object)this.counters()).add("Message", (Object)this.message()).add("TotalJobs", (Object)this.totalJobs()).add("CompletedJobs", (Object)this.completedJobs()).add("BillingMethod", (Object)this.billingMethodAsString()).add("DeviceMinutes", (Object)this.deviceMinutes()).add("NetworkProfile", (Object)this.networkProfile()).add("ParsingResultUrl", (Object)this.parsingResultUrl()).add("ResultCode", (Object)this.resultCodeAsString()).add("Seed", (Object)this.seed()).add("AppUpload", (Object)this.appUpload()).add("EventCount", (Object)this.eventCount()).add("JobTimeoutMinutes", (Object)this.jobTimeoutMinutes()).add("DevicePoolArn", (Object)this.devicePoolArn()).add("Locale", (Object)this.locale()).add("Radios", (Object)this.radios()).add("Location", (Object)this.location()).add("CustomerArtifactPaths", (Object)this.customerArtifactPaths()).add("WebUrl", (Object)this.webUrl()).add("SkipAppResign", (Object)this.skipAppResign()).add("TestSpecArn", (Object)this.testSpecArn()).add("DeviceSelectionResult", (Object)this.deviceSelectionResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "result": {
                return Optional.ofNullable(clazz.cast(this.resultAsString()));
            }
            case "started": {
                return Optional.ofNullable(clazz.cast(this.started()));
            }
            case "stopped": {
                return Optional.ofNullable(clazz.cast(this.stopped()));
            }
            case "counters": {
                return Optional.ofNullable(clazz.cast(this.counters()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "totalJobs": {
                return Optional.ofNullable(clazz.cast(this.totalJobs()));
            }
            case "completedJobs": {
                return Optional.ofNullable(clazz.cast(this.completedJobs()));
            }
            case "billingMethod": {
                return Optional.ofNullable(clazz.cast(this.billingMethodAsString()));
            }
            case "deviceMinutes": {
                return Optional.ofNullable(clazz.cast(this.deviceMinutes()));
            }
            case "networkProfile": {
                return Optional.ofNullable(clazz.cast(this.networkProfile()));
            }
            case "parsingResultUrl": {
                return Optional.ofNullable(clazz.cast(this.parsingResultUrl()));
            }
            case "resultCode": {
                return Optional.ofNullable(clazz.cast(this.resultCodeAsString()));
            }
            case "seed": {
                return Optional.ofNullable(clazz.cast(this.seed()));
            }
            case "appUpload": {
                return Optional.ofNullable(clazz.cast(this.appUpload()));
            }
            case "eventCount": {
                return Optional.ofNullable(clazz.cast(this.eventCount()));
            }
            case "jobTimeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.jobTimeoutMinutes()));
            }
            case "devicePoolArn": {
                return Optional.ofNullable(clazz.cast(this.devicePoolArn()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "radios": {
                return Optional.ofNullable(clazz.cast(this.radios()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "customerArtifactPaths": {
                return Optional.ofNullable(clazz.cast(this.customerArtifactPaths()));
            }
            case "webUrl": {
                return Optional.ofNullable(clazz.cast(this.webUrl()));
            }
            case "skipAppResign": {
                return Optional.ofNullable(clazz.cast(this.skipAppResign()));
            }
            case "testSpecArn": {
                return Optional.ofNullable(clazz.cast(this.testSpecArn()));
            }
            case "deviceSelectionResult": {
                return Optional.ofNullable(clazz.cast(this.deviceSelectionResult()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Run, T> g) {
        return obj -> g.apply((Run)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String type;
        private String platform;
        private Instant created;
        private String status;
        private String result;
        private Instant started;
        private Instant stopped;
        private Counters counters;
        private String message;
        private Integer totalJobs;
        private Integer completedJobs;
        private String billingMethod;
        private DeviceMinutes deviceMinutes;
        private NetworkProfile networkProfile;
        private String parsingResultUrl;
        private String resultCode;
        private Integer seed;
        private String appUpload;
        private Integer eventCount;
        private Integer jobTimeoutMinutes;
        private String devicePoolArn;
        private String locale;
        private Radios radios;
        private Location location;
        private CustomerArtifactPaths customerArtifactPaths;
        private String webUrl;
        private Boolean skipAppResign;
        private String testSpecArn;
        private DeviceSelectionResult deviceSelectionResult;

        private BuilderImpl() {
        }

        private BuilderImpl(Run model) {
            this.arn(model.arn);
            this.name(model.name);
            this.type(model.type);
            this.platform(model.platform);
            this.created(model.created);
            this.status(model.status);
            this.result(model.result);
            this.started(model.started);
            this.stopped(model.stopped);
            this.counters(model.counters);
            this.message(model.message);
            this.totalJobs(model.totalJobs);
            this.completedJobs(model.completedJobs);
            this.billingMethod(model.billingMethod);
            this.deviceMinutes(model.deviceMinutes);
            this.networkProfile(model.networkProfile);
            this.parsingResultUrl(model.parsingResultUrl);
            this.resultCode(model.resultCode);
            this.seed(model.seed);
            this.appUpload(model.appUpload);
            this.eventCount(model.eventCount);
            this.jobTimeoutMinutes(model.jobTimeoutMinutes);
            this.devicePoolArn(model.devicePoolArn);
            this.locale(model.locale);
            this.radios(model.radios);
            this.location(model.location);
            this.customerArtifactPaths(model.customerArtifactPaths);
            this.webUrl(model.webUrl);
            this.skipAppResign(model.skipAppResign);
            this.testSpecArn(model.testSpecArn);
            this.deviceSelectionResult(model.deviceSelectionResult);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(DevicePlatform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getResult() {
            return this.result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final Instant getStarted() {
            return this.started;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final Instant getStopped() {
            return this.stopped;
        }

        public final void setStopped(Instant stopped) {
            this.stopped = stopped;
        }

        @Override
        public final Builder stopped(Instant stopped) {
            this.stopped = stopped;
            return this;
        }

        public final Counters.Builder getCounters() {
            return this.counters != null ? this.counters.toBuilder() : null;
        }

        public final void setCounters(Counters.BuilderImpl counters) {
            this.counters = counters != null ? counters.build() : null;
        }

        @Override
        public final Builder counters(Counters counters) {
            this.counters = counters;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Integer getTotalJobs() {
            return this.totalJobs;
        }

        public final void setTotalJobs(Integer totalJobs) {
            this.totalJobs = totalJobs;
        }

        @Override
        public final Builder totalJobs(Integer totalJobs) {
            this.totalJobs = totalJobs;
            return this;
        }

        public final Integer getCompletedJobs() {
            return this.completedJobs;
        }

        public final void setCompletedJobs(Integer completedJobs) {
            this.completedJobs = completedJobs;
        }

        @Override
        public final Builder completedJobs(Integer completedJobs) {
            this.completedJobs = completedJobs;
            return this;
        }

        public final String getBillingMethod() {
            return this.billingMethod;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod == null ? null : billingMethod.toString());
            return this;
        }

        public final DeviceMinutes.Builder getDeviceMinutes() {
            return this.deviceMinutes != null ? this.deviceMinutes.toBuilder() : null;
        }

        public final void setDeviceMinutes(DeviceMinutes.BuilderImpl deviceMinutes) {
            this.deviceMinutes = deviceMinutes != null ? deviceMinutes.build() : null;
        }

        @Override
        public final Builder deviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
            return this;
        }

        public final NetworkProfile.Builder getNetworkProfile() {
            return this.networkProfile != null ? this.networkProfile.toBuilder() : null;
        }

        public final void setNetworkProfile(NetworkProfile.BuilderImpl networkProfile) {
            this.networkProfile = networkProfile != null ? networkProfile.build() : null;
        }

        @Override
        public final Builder networkProfile(NetworkProfile networkProfile) {
            this.networkProfile = networkProfile;
            return this;
        }

        public final String getParsingResultUrl() {
            return this.parsingResultUrl;
        }

        public final void setParsingResultUrl(String parsingResultUrl) {
            this.parsingResultUrl = parsingResultUrl;
        }

        @Override
        public final Builder parsingResultUrl(String parsingResultUrl) {
            this.parsingResultUrl = parsingResultUrl;
            return this;
        }

        public final String getResultCode() {
            return this.resultCode;
        }

        public final void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        @Override
        public final Builder resultCode(String resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        @Override
        public final Builder resultCode(ExecutionResultCode resultCode) {
            this.resultCode(resultCode == null ? null : resultCode.toString());
            return this;
        }

        public final Integer getSeed() {
            return this.seed;
        }

        public final void setSeed(Integer seed) {
            this.seed = seed;
        }

        @Override
        public final Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public final String getAppUpload() {
            return this.appUpload;
        }

        public final void setAppUpload(String appUpload) {
            this.appUpload = appUpload;
        }

        @Override
        public final Builder appUpload(String appUpload) {
            this.appUpload = appUpload;
            return this;
        }

        public final Integer getEventCount() {
            return this.eventCount;
        }

        public final void setEventCount(Integer eventCount) {
            this.eventCount = eventCount;
        }

        @Override
        public final Builder eventCount(Integer eventCount) {
            this.eventCount = eventCount;
            return this;
        }

        public final Integer getJobTimeoutMinutes() {
            return this.jobTimeoutMinutes;
        }

        public final void setJobTimeoutMinutes(Integer jobTimeoutMinutes) {
            this.jobTimeoutMinutes = jobTimeoutMinutes;
        }

        @Override
        public final Builder jobTimeoutMinutes(Integer jobTimeoutMinutes) {
            this.jobTimeoutMinutes = jobTimeoutMinutes;
            return this;
        }

        public final String getDevicePoolArn() {
            return this.devicePoolArn;
        }

        public final void setDevicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
        }

        @Override
        public final Builder devicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final Radios.Builder getRadios() {
            return this.radios != null ? this.radios.toBuilder() : null;
        }

        public final void setRadios(Radios.BuilderImpl radios) {
            this.radios = radios != null ? radios.build() : null;
        }

        @Override
        public final Builder radios(Radios radios) {
            this.radios = radios;
            return this;
        }

        public final Location.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final CustomerArtifactPaths.Builder getCustomerArtifactPaths() {
            return this.customerArtifactPaths != null ? this.customerArtifactPaths.toBuilder() : null;
        }

        public final void setCustomerArtifactPaths(CustomerArtifactPaths.BuilderImpl customerArtifactPaths) {
            this.customerArtifactPaths = customerArtifactPaths != null ? customerArtifactPaths.build() : null;
        }

        @Override
        public final Builder customerArtifactPaths(CustomerArtifactPaths customerArtifactPaths) {
            this.customerArtifactPaths = customerArtifactPaths;
            return this;
        }

        public final String getWebUrl() {
            return this.webUrl;
        }

        public final void setWebUrl(String webUrl) {
            this.webUrl = webUrl;
        }

        @Override
        public final Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            return this;
        }

        public final Boolean getSkipAppResign() {
            return this.skipAppResign;
        }

        public final void setSkipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
        }

        @Override
        public final Builder skipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
            return this;
        }

        public final String getTestSpecArn() {
            return this.testSpecArn;
        }

        public final void setTestSpecArn(String testSpecArn) {
            this.testSpecArn = testSpecArn;
        }

        @Override
        public final Builder testSpecArn(String testSpecArn) {
            this.testSpecArn = testSpecArn;
            return this;
        }

        public final DeviceSelectionResult.Builder getDeviceSelectionResult() {
            return this.deviceSelectionResult != null ? this.deviceSelectionResult.toBuilder() : null;
        }

        public final void setDeviceSelectionResult(DeviceSelectionResult.BuilderImpl deviceSelectionResult) {
            this.deviceSelectionResult = deviceSelectionResult != null ? deviceSelectionResult.build() : null;
        }

        @Override
        public final Builder deviceSelectionResult(DeviceSelectionResult deviceSelectionResult) {
            this.deviceSelectionResult = deviceSelectionResult;
            return this;
        }

        public Run build() {
            return new Run(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Run> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(TestType var1);

        public Builder platform(String var1);

        public Builder platform(DevicePlatform var1);

        public Builder created(Instant var1);

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder result(String var1);

        public Builder result(ExecutionResult var1);

        public Builder started(Instant var1);

        public Builder stopped(Instant var1);

        public Builder counters(Counters var1);

        default public Builder counters(Consumer<Counters.Builder> counters) {
            return this.counters((Counters)((Counters.Builder)Counters.builder().applyMutation(counters)).build());
        }

        public Builder message(String var1);

        public Builder totalJobs(Integer var1);

        public Builder completedJobs(Integer var1);

        public Builder billingMethod(String var1);

        public Builder billingMethod(BillingMethod var1);

        public Builder deviceMinutes(DeviceMinutes var1);

        default public Builder deviceMinutes(Consumer<DeviceMinutes.Builder> deviceMinutes) {
            return this.deviceMinutes((DeviceMinutes)((DeviceMinutes.Builder)DeviceMinutes.builder().applyMutation(deviceMinutes)).build());
        }

        public Builder networkProfile(NetworkProfile var1);

        default public Builder networkProfile(Consumer<NetworkProfile.Builder> networkProfile) {
            return this.networkProfile((NetworkProfile)((NetworkProfile.Builder)NetworkProfile.builder().applyMutation(networkProfile)).build());
        }

        public Builder parsingResultUrl(String var1);

        public Builder resultCode(String var1);

        public Builder resultCode(ExecutionResultCode var1);

        public Builder seed(Integer var1);

        public Builder appUpload(String var1);

        public Builder eventCount(Integer var1);

        public Builder jobTimeoutMinutes(Integer var1);

        public Builder devicePoolArn(String var1);

        public Builder locale(String var1);

        public Builder radios(Radios var1);

        default public Builder radios(Consumer<Radios.Builder> radios) {
            return this.radios((Radios)((Radios.Builder)Radios.builder().applyMutation(radios)).build());
        }

        public Builder location(Location var1);

        default public Builder location(Consumer<Location.Builder> location) {
            return this.location((Location)((Location.Builder)Location.builder().applyMutation(location)).build());
        }

        public Builder customerArtifactPaths(CustomerArtifactPaths var1);

        default public Builder customerArtifactPaths(Consumer<CustomerArtifactPaths.Builder> customerArtifactPaths) {
            return this.customerArtifactPaths((CustomerArtifactPaths)((CustomerArtifactPaths.Builder)CustomerArtifactPaths.builder().applyMutation(customerArtifactPaths)).build());
        }

        public Builder webUrl(String var1);

        public Builder skipAppResign(Boolean var1);

        public Builder testSpecArn(String var1);

        public Builder deviceSelectionResult(DeviceSelectionResult var1);

        default public Builder deviceSelectionResult(Consumer<DeviceSelectionResult.Builder> deviceSelectionResult) {
            return this.deviceSelectionResult((DeviceSelectionResult)((DeviceSelectionResult.Builder)DeviceSelectionResult.builder().applyMutation(deviceSelectionResult)).build());
        }
    }
}

