/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsResponse;

public class ListTestGridSessionActionsIterable
implements SdkIterable<ListTestGridSessionActionsResponse> {
    private final DeviceFarmClient client;
    private final ListTestGridSessionActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestGridSessionActionsIterable(DeviceFarmClient client, ListTestGridSessionActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTestGridSessionActionsResponseFetcher();
    }

    public Iterator<ListTestGridSessionActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTestGridSessionActionsResponseFetcher
    implements SyncPageFetcher<ListTestGridSessionActionsResponse> {
        private ListTestGridSessionActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestGridSessionActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTestGridSessionActionsResponse nextPage(ListTestGridSessionActionsResponse previousPage) {
            if (previousPage == null) {
                return ListTestGridSessionActionsIterable.this.client.listTestGridSessionActions(ListTestGridSessionActionsIterable.this.firstRequest);
            }
            return ListTestGridSessionActionsIterable.this.client.listTestGridSessionActions((ListTestGridSessionActionsRequest)((Object)ListTestGridSessionActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

