/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.services.devicefarm.model.InstanceLabelsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDeviceInstanceRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, UpdateDeviceInstanceRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdateDeviceInstanceRequest.getter(UpdateDeviceInstanceRequest::arn)).setter(UpdateDeviceInstanceRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileArn").getter(UpdateDeviceInstanceRequest.getter(UpdateDeviceInstanceRequest::profileArn)).setter(UpdateDeviceInstanceRequest.setter(Builder::profileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileArn").build()}).build();
    private static final SdkField<List<String>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("labels").getter(UpdateDeviceInstanceRequest.getter(UpdateDeviceInstanceRequest::labels)).setter(UpdateDeviceInstanceRequest.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, PROFILE_ARN_FIELD, LABELS_FIELD));
    private final String arn;
    private final String profileArn;
    private final List<String> labels;

    private UpdateDeviceInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.profileArn = builder.profileArn;
        this.labels = builder.labels;
    }

    public final String arn() {
        return this.arn;
    }

    public final String profileArn() {
        return this.profileArn;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<String> labels() {
        return this.labels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeviceInstanceRequest)) {
            return false;
        }
        UpdateDeviceInstanceRequest other = (UpdateDeviceInstanceRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.profileArn(), other.profileArn()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDeviceInstanceRequest").add("Arn", (Object)this.arn()).add("ProfileArn", (Object)this.profileArn()).add("Labels", this.hasLabels() ? this.labels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "profileArn": {
                return Optional.ofNullable(clazz.cast(this.profileArn()));
            }
            case "labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeviceInstanceRequest, T> g) {
        return obj -> g.apply((UpdateDeviceInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String arn;
        private String profileArn;
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeviceInstanceRequest model) {
            super(model);
            this.arn(model.arn);
            this.profileArn(model.profileArn);
            this.labels(model.labels);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getProfileArn() {
            return this.profileArn;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        @Transient
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final Collection<String> getLabels() {
            if (this.labels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labels;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = InstanceLabelsCopier.copy(labels);
        }

        @Override
        @Transient
        public final Builder labels(Collection<String> labels) {
            this.labels = InstanceLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDeviceInstanceRequest build() {
            return new UpdateDeviceInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeviceFarmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDeviceInstanceRequest> {
        public Builder arn(String var1);

        public Builder profileArn(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

