/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.AndroidPathsCopier;
import software.amazon.awssdk.services.devicefarm.model.DeviceHostPathsCopier;
import software.amazon.awssdk.services.devicefarm.model.IosPathsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomerArtifactPaths
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomerArtifactPaths> {
    private static final SdkField<List<String>> IOS_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("iosPaths").getter(CustomerArtifactPaths.getter(CustomerArtifactPaths::iosPaths)).setter(CustomerArtifactPaths.setter(Builder::iosPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iosPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ANDROID_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("androidPaths").getter(CustomerArtifactPaths.getter(CustomerArtifactPaths::androidPaths)).setter(CustomerArtifactPaths.setter(Builder::androidPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("androidPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DEVICE_HOST_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deviceHostPaths").getter(CustomerArtifactPaths.getter(CustomerArtifactPaths::deviceHostPaths)).setter(CustomerArtifactPaths.setter(Builder::deviceHostPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceHostPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IOS_PATHS_FIELD, ANDROID_PATHS_FIELD, DEVICE_HOST_PATHS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> iosPaths;
    private final List<String> androidPaths;
    private final List<String> deviceHostPaths;

    private CustomerArtifactPaths(BuilderImpl builder) {
        this.iosPaths = builder.iosPaths;
        this.androidPaths = builder.androidPaths;
        this.deviceHostPaths = builder.deviceHostPaths;
    }

    public final boolean hasIosPaths() {
        return this.iosPaths != null && !(this.iosPaths instanceof SdkAutoConstructList);
    }

    public final List<String> iosPaths() {
        return this.iosPaths;
    }

    public final boolean hasAndroidPaths() {
        return this.androidPaths != null && !(this.androidPaths instanceof SdkAutoConstructList);
    }

    public final List<String> androidPaths() {
        return this.androidPaths;
    }

    public final boolean hasDeviceHostPaths() {
        return this.deviceHostPaths != null && !(this.deviceHostPaths instanceof SdkAutoConstructList);
    }

    public final List<String> deviceHostPaths() {
        return this.deviceHostPaths;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIosPaths() ? this.iosPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAndroidPaths() ? this.androidPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceHostPaths() ? this.deviceHostPaths() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerArtifactPaths)) {
            return false;
        }
        CustomerArtifactPaths other = (CustomerArtifactPaths)obj;
        return this.hasIosPaths() == other.hasIosPaths() && Objects.equals(this.iosPaths(), other.iosPaths()) && this.hasAndroidPaths() == other.hasAndroidPaths() && Objects.equals(this.androidPaths(), other.androidPaths()) && this.hasDeviceHostPaths() == other.hasDeviceHostPaths() && Objects.equals(this.deviceHostPaths(), other.deviceHostPaths());
    }

    public final String toString() {
        return ToString.builder((String)"CustomerArtifactPaths").add("IosPaths", this.hasIosPaths() ? this.iosPaths() : null).add("AndroidPaths", this.hasAndroidPaths() ? this.androidPaths() : null).add("DeviceHostPaths", this.hasDeviceHostPaths() ? this.deviceHostPaths() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "iosPaths": {
                return Optional.ofNullable(clazz.cast(this.iosPaths()));
            }
            case "androidPaths": {
                return Optional.ofNullable(clazz.cast(this.androidPaths()));
            }
            case "deviceHostPaths": {
                return Optional.ofNullable(clazz.cast(this.deviceHostPaths()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomerArtifactPaths, T> g) {
        return obj -> g.apply((CustomerArtifactPaths)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> iosPaths = DefaultSdkAutoConstructList.getInstance();
        private List<String> androidPaths = DefaultSdkAutoConstructList.getInstance();
        private List<String> deviceHostPaths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerArtifactPaths model) {
            this.iosPaths(model.iosPaths);
            this.androidPaths(model.androidPaths);
            this.deviceHostPaths(model.deviceHostPaths);
        }

        public final Collection<String> getIosPaths() {
            if (this.iosPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.iosPaths;
        }

        public final void setIosPaths(Collection<String> iosPaths) {
            this.iosPaths = IosPathsCopier.copy(iosPaths);
        }

        @Override
        @Transient
        public final Builder iosPaths(Collection<String> iosPaths) {
            this.iosPaths = IosPathsCopier.copy(iosPaths);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder iosPaths(String ... iosPaths) {
            this.iosPaths(Arrays.asList(iosPaths));
            return this;
        }

        public final Collection<String> getAndroidPaths() {
            if (this.androidPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.androidPaths;
        }

        public final void setAndroidPaths(Collection<String> androidPaths) {
            this.androidPaths = AndroidPathsCopier.copy(androidPaths);
        }

        @Override
        @Transient
        public final Builder androidPaths(Collection<String> androidPaths) {
            this.androidPaths = AndroidPathsCopier.copy(androidPaths);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder androidPaths(String ... androidPaths) {
            this.androidPaths(Arrays.asList(androidPaths));
            return this;
        }

        public final Collection<String> getDeviceHostPaths() {
            if (this.deviceHostPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deviceHostPaths;
        }

        public final void setDeviceHostPaths(Collection<String> deviceHostPaths) {
            this.deviceHostPaths = DeviceHostPathsCopier.copy(deviceHostPaths);
        }

        @Override
        @Transient
        public final Builder deviceHostPaths(Collection<String> deviceHostPaths) {
            this.deviceHostPaths = DeviceHostPathsCopier.copy(deviceHostPaths);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deviceHostPaths(String ... deviceHostPaths) {
            this.deviceHostPaths(Arrays.asList(deviceHostPaths));
            return this;
        }

        public CustomerArtifactPaths build() {
            return new CustomerArtifactPaths(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomerArtifactPaths> {
        public Builder iosPaths(Collection<String> var1);

        public Builder iosPaths(String ... var1);

        public Builder androidPaths(Collection<String> var1);

        public Builder androidPaths(String ... var1);

        public Builder deviceHostPaths(Collection<String> var1);

        public Builder deviceHostPaths(String ... var1);
    }
}

