/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the status result for a device offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOfferingStatusResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<GetOfferingStatusResponse.Builder, GetOfferingStatusResponse> {
    private static final SdkField<Map<String, OfferingStatus>> CURRENT_FIELD = SdkField
            .<Map<String, OfferingStatus>> builder(MarshallingType.MAP)
            .memberName("current")
            .getter(getter(GetOfferingStatusResponse::current))
            .setter(setter(Builder::current))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("current").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<OfferingStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(OfferingStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, OfferingStatus>> NEXT_PERIOD_FIELD = SdkField
            .<Map<String, OfferingStatus>> builder(MarshallingType.MAP)
            .memberName("nextPeriod")
            .getter(getter(GetOfferingStatusResponse::nextPeriod))
            .setter(setter(Builder::nextPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPeriod").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<OfferingStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(OfferingStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetOfferingStatusResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_FIELD,
            NEXT_PERIOD_FIELD, NEXT_TOKEN_FIELD));

    private final Map<String, OfferingStatus> current;

    private final Map<String, OfferingStatus> nextPeriod;

    private final String nextToken;

    private GetOfferingStatusResponse(BuilderImpl builder) {
        super(builder);
        this.current = builder.current;
        this.nextPeriod = builder.nextPeriod;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Current property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCurrent() {
        return current != null && !(current instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * When specified, gets the offering status for the current period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCurrent()} to see if a value was sent in this field.
     * </p>
     * 
     * @return When specified, gets the offering status for the current period.
     */
    public final Map<String, OfferingStatus> current() {
        return current;
    }

    /**
     * Returns true if the NextPeriod property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasNextPeriod() {
        return nextPeriod != null && !(nextPeriod instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * When specified, gets the offering status for the next period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNextPeriod()} to see if a value was sent in this field.
     * </p>
     * 
     * @return When specified, gets the offering status for the next period.
     */
    public final Map<String, OfferingStatus> nextPeriod() {
        return nextPeriod;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCurrent() ? current() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNextPeriod() ? nextPeriod() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOfferingStatusResponse)) {
            return false;
        }
        GetOfferingStatusResponse other = (GetOfferingStatusResponse) obj;
        return hasCurrent() == other.hasCurrent() && Objects.equals(current(), other.current())
                && hasNextPeriod() == other.hasNextPeriod() && Objects.equals(nextPeriod(), other.nextPeriod())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOfferingStatusResponse").add("Current", hasCurrent() ? current() : null)
                .add("NextPeriod", hasNextPeriod() ? nextPeriod() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "current":
            return Optional.ofNullable(clazz.cast(current()));
        case "nextPeriod":
            return Optional.ofNullable(clazz.cast(nextPeriod()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOfferingStatusResponse, T> g) {
        return obj -> g.apply((GetOfferingStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetOfferingStatusResponse> {
        /**
         * <p>
         * When specified, gets the offering status for the current period.
         * </p>
         * 
         * @param current
         *        When specified, gets the offering status for the current period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder current(Map<String, OfferingStatus> current);

        /**
         * <p>
         * When specified, gets the offering status for the next period.
         * </p>
         * 
         * @param nextPeriod
         *        When specified, gets the offering status for the next period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPeriod(Map<String, OfferingStatus> nextPeriod);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private Map<String, OfferingStatus> current = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, OfferingStatus> nextPeriod = DefaultSdkAutoConstructMap.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOfferingStatusResponse model) {
            super(model);
            current(model.current);
            nextPeriod(model.nextPeriod);
            nextToken(model.nextToken);
        }

        public final Map<String, OfferingStatus.Builder> getCurrent() {
            if (current instanceof SdkAutoConstructMap) {
                return null;
            }
            return current != null ? CollectionUtils.mapValues(current, OfferingStatus::toBuilder) : null;
        }

        @Override
        public final Builder current(Map<String, OfferingStatus> current) {
            this.current = OfferingStatusMapCopier.copy(current);
            return this;
        }

        public final void setCurrent(Map<String, OfferingStatus.BuilderImpl> current) {
            this.current = OfferingStatusMapCopier.copyFromBuilder(current);
        }

        public final Map<String, OfferingStatus.Builder> getNextPeriod() {
            if (nextPeriod instanceof SdkAutoConstructMap) {
                return null;
            }
            return nextPeriod != null ? CollectionUtils.mapValues(nextPeriod, OfferingStatus::toBuilder) : null;
        }

        @Override
        public final Builder nextPeriod(Map<String, OfferingStatus> nextPeriod) {
            this.nextPeriod = OfferingStatusMapCopier.copy(nextPeriod);
            return this;
        }

        public final void setNextPeriod(Map<String, OfferingStatus.BuilderImpl> nextPeriod) {
            this.nextPeriod = OfferingStatusMapCopier.copyFromBuilder(nextPeriod);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetOfferingStatusResponse build() {
            return new GetOfferingStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
