/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents configuration information about a test run, such as the execution timeout (in minutes).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionConfiguration.Builder, ExecutionConfiguration> {
    private static final SdkField<Integer> JOB_TIMEOUT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("jobTimeoutMinutes").getter(getter(ExecutionConfiguration::jobTimeoutMinutes))
            .setter(setter(Builder::jobTimeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTimeoutMinutes").build()).build();

    private static final SdkField<Boolean> ACCOUNTS_CLEANUP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("accountsCleanup").getter(getter(ExecutionConfiguration::accountsCleanup))
            .setter(setter(Builder::accountsCleanup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountsCleanup").build()).build();

    private static final SdkField<Boolean> APP_PACKAGES_CLEANUP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("appPackagesCleanup").getter(getter(ExecutionConfiguration::appPackagesCleanup))
            .setter(setter(Builder::appPackagesCleanup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appPackagesCleanup").build())
            .build();

    private static final SdkField<Boolean> VIDEO_CAPTURE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("videoCapture").getter(getter(ExecutionConfiguration::videoCapture))
            .setter(setter(Builder::videoCapture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoCapture").build()).build();

    private static final SdkField<Boolean> SKIP_APP_RESIGN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("skipAppResign").getter(getter(ExecutionConfiguration::skipAppResign))
            .setter(setter(Builder::skipAppResign))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skipAppResign").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_TIMEOUT_MINUTES_FIELD,
            ACCOUNTS_CLEANUP_FIELD, APP_PACKAGES_CLEANUP_FIELD, VIDEO_CAPTURE_FIELD, SKIP_APP_RESIGN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer jobTimeoutMinutes;

    private final Boolean accountsCleanup;

    private final Boolean appPackagesCleanup;

    private final Boolean videoCapture;

    private final Boolean skipAppResign;

    private ExecutionConfiguration(BuilderImpl builder) {
        this.jobTimeoutMinutes = builder.jobTimeoutMinutes;
        this.accountsCleanup = builder.accountsCleanup;
        this.appPackagesCleanup = builder.appPackagesCleanup;
        this.videoCapture = builder.videoCapture;
        this.skipAppResign = builder.skipAppResign;
    }

    /**
     * <p>
     * The number of minutes a test run executes before it times out.
     * </p>
     * 
     * @return The number of minutes a test run executes before it times out.
     */
    public final Integer jobTimeoutMinutes() {
        return jobTimeoutMinutes;
    }

    /**
     * <p>
     * True if account cleanup is enabled at the beginning of the test. Otherwise, false.
     * </p>
     * 
     * @return True if account cleanup is enabled at the beginning of the test. Otherwise, false.
     */
    public final Boolean accountsCleanup() {
        return accountsCleanup;
    }

    /**
     * <p>
     * True if app package cleanup is enabled at the beginning of the test. Otherwise, false.
     * </p>
     * 
     * @return True if app package cleanup is enabled at the beginning of the test. Otherwise, false.
     */
    public final Boolean appPackagesCleanup() {
        return appPackagesCleanup;
    }

    /**
     * <p>
     * Set to true to enable video capture. Otherwise, set to false. The default is true.
     * </p>
     * 
     * @return Set to true to enable video capture. Otherwise, set to false. The default is true.
     */
    public final Boolean videoCapture() {
        return videoCapture;
    }

    /**
     * <p>
     * When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public devices,
     * Device Farm always signs your apps again.
     * </p>
     * <p>
     * For more information about how Device Farm re-signs your apps, see <a
     * href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device Farm FAQs</i>.
     * </p>
     * 
     * @return When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
     *         devices, Device Farm always signs your apps again.</p>
     *         <p>
     *         For more information about how Device Farm re-signs your apps, see <a
     *         href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device Farm
     *         FAQs</i>.
     */
    public final Boolean skipAppResign() {
        return skipAppResign;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobTimeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(accountsCleanup());
        hashCode = 31 * hashCode + Objects.hashCode(appPackagesCleanup());
        hashCode = 31 * hashCode + Objects.hashCode(videoCapture());
        hashCode = 31 * hashCode + Objects.hashCode(skipAppResign());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionConfiguration)) {
            return false;
        }
        ExecutionConfiguration other = (ExecutionConfiguration) obj;
        return Objects.equals(jobTimeoutMinutes(), other.jobTimeoutMinutes())
                && Objects.equals(accountsCleanup(), other.accountsCleanup())
                && Objects.equals(appPackagesCleanup(), other.appPackagesCleanup())
                && Objects.equals(videoCapture(), other.videoCapture()) && Objects.equals(skipAppResign(), other.skipAppResign());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionConfiguration").add("JobTimeoutMinutes", jobTimeoutMinutes())
                .add("AccountsCleanup", accountsCleanup()).add("AppPackagesCleanup", appPackagesCleanup())
                .add("VideoCapture", videoCapture()).add("SkipAppResign", skipAppResign()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobTimeoutMinutes":
            return Optional.ofNullable(clazz.cast(jobTimeoutMinutes()));
        case "accountsCleanup":
            return Optional.ofNullable(clazz.cast(accountsCleanup()));
        case "appPackagesCleanup":
            return Optional.ofNullable(clazz.cast(appPackagesCleanup()));
        case "videoCapture":
            return Optional.ofNullable(clazz.cast(videoCapture()));
        case "skipAppResign":
            return Optional.ofNullable(clazz.cast(skipAppResign()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionConfiguration, T> g) {
        return obj -> g.apply((ExecutionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionConfiguration> {
        /**
         * <p>
         * The number of minutes a test run executes before it times out.
         * </p>
         * 
         * @param jobTimeoutMinutes
         *        The number of minutes a test run executes before it times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTimeoutMinutes(Integer jobTimeoutMinutes);

        /**
         * <p>
         * True if account cleanup is enabled at the beginning of the test. Otherwise, false.
         * </p>
         * 
         * @param accountsCleanup
         *        True if account cleanup is enabled at the beginning of the test. Otherwise, false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountsCleanup(Boolean accountsCleanup);

        /**
         * <p>
         * True if app package cleanup is enabled at the beginning of the test. Otherwise, false.
         * </p>
         * 
         * @param appPackagesCleanup
         *        True if app package cleanup is enabled at the beginning of the test. Otherwise, false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appPackagesCleanup(Boolean appPackagesCleanup);

        /**
         * <p>
         * Set to true to enable video capture. Otherwise, set to false. The default is true.
         * </p>
         * 
         * @param videoCapture
         *        Set to true to enable video capture. Otherwise, set to false. The default is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoCapture(Boolean videoCapture);

        /**
         * <p>
         * When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For public
         * devices, Device Farm always signs your apps again.
         * </p>
         * <p>
         * For more information about how Device Farm re-signs your apps, see <a
         * href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device Farm FAQs</i>.
         * </p>
         * 
         * @param skipAppResign
         *        When set to <code>true</code>, for private devices, Device Farm does not sign your app again. For
         *        public devices, Device Farm always signs your apps again.</p>
         *        <p>
         *        For more information about how Device Farm re-signs your apps, see <a
         *        href="https://aws.amazon.com/device-farm/faq/">Do you modify my app?</a> in the <i>AWS Device Farm
         *        FAQs</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipAppResign(Boolean skipAppResign);
    }

    static final class BuilderImpl implements Builder {
        private Integer jobTimeoutMinutes;

        private Boolean accountsCleanup;

        private Boolean appPackagesCleanup;

        private Boolean videoCapture;

        private Boolean skipAppResign;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionConfiguration model) {
            jobTimeoutMinutes(model.jobTimeoutMinutes);
            accountsCleanup(model.accountsCleanup);
            appPackagesCleanup(model.appPackagesCleanup);
            videoCapture(model.videoCapture);
            skipAppResign(model.skipAppResign);
        }

        public final Integer getJobTimeoutMinutes() {
            return jobTimeoutMinutes;
        }

        @Override
        public final Builder jobTimeoutMinutes(Integer jobTimeoutMinutes) {
            this.jobTimeoutMinutes = jobTimeoutMinutes;
            return this;
        }

        public final void setJobTimeoutMinutes(Integer jobTimeoutMinutes) {
            this.jobTimeoutMinutes = jobTimeoutMinutes;
        }

        public final Boolean getAccountsCleanup() {
            return accountsCleanup;
        }

        @Override
        public final Builder accountsCleanup(Boolean accountsCleanup) {
            this.accountsCleanup = accountsCleanup;
            return this;
        }

        public final void setAccountsCleanup(Boolean accountsCleanup) {
            this.accountsCleanup = accountsCleanup;
        }

        public final Boolean getAppPackagesCleanup() {
            return appPackagesCleanup;
        }

        @Override
        public final Builder appPackagesCleanup(Boolean appPackagesCleanup) {
            this.appPackagesCleanup = appPackagesCleanup;
            return this;
        }

        public final void setAppPackagesCleanup(Boolean appPackagesCleanup) {
            this.appPackagesCleanup = appPackagesCleanup;
        }

        public final Boolean getVideoCapture() {
            return videoCapture;
        }

        @Override
        public final Builder videoCapture(Boolean videoCapture) {
            this.videoCapture = videoCapture;
            return this;
        }

        public final void setVideoCapture(Boolean videoCapture) {
            this.videoCapture = videoCapture;
        }

        public final Boolean getSkipAppResign() {
            return skipAppResign;
        }

        @Override
        public final Builder skipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
            return this;
        }

        public final void setSkipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
        }

        @Override
        public ExecutionConfiguration build() {
            return new ExecutionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
