/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse;
import software.amazon.awssdk.services.devicefarm.model.Upload;

public class ListUploadsIterable
implements SdkIterable<ListUploadsResponse> {
    private final DeviceFarmClient client;
    private final ListUploadsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUploadsIterable(DeviceFarmClient client, ListUploadsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListUploadsResponseFetcher();
    }

    public Iterator<ListUploadsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Upload> uploads() {
        Function<ListUploadsResponse, Iterator> getIterator = response -> {
            if (response != null && response.uploads() != null) {
                return response.uploads().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUploadsResponseFetcher
    implements SyncPageFetcher<ListUploadsResponse> {
        private ListUploadsResponseFetcher() {
        }

        public boolean hasNextPage(ListUploadsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUploadsResponse nextPage(ListUploadsResponse previousPage) {
            if (previousPage == null) {
                return ListUploadsIterable.this.client.listUploads(ListUploadsIterable.this.firstRequest);
            }
            return ListUploadsIterable.this.client.listUploads((ListUploadsRequest)((Object)ListUploadsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

