/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.PackageIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceProfile> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(InstanceProfile.getter(InstanceProfile::arn)).setter(InstanceProfile.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Boolean> PACKAGE_CLEANUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("packageCleanup").getter(InstanceProfile.getter(InstanceProfile::packageCleanup)).setter(InstanceProfile.setter(Builder::packageCleanup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageCleanup").build()}).build();
    private static final SdkField<List<String>> EXCLUDE_APP_PACKAGES_FROM_CLEANUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("excludeAppPackagesFromCleanup").getter(InstanceProfile.getter(InstanceProfile::excludeAppPackagesFromCleanup)).setter(InstanceProfile.setter(Builder::excludeAppPackagesFromCleanup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludeAppPackagesFromCleanup").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> REBOOT_AFTER_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("rebootAfterUse").getter(InstanceProfile.getter(InstanceProfile::rebootAfterUse)).setter(InstanceProfile.setter(Builder::rebootAfterUse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rebootAfterUse").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(InstanceProfile.getter(InstanceProfile::name)).setter(InstanceProfile.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(InstanceProfile.getter(InstanceProfile::description)).setter(InstanceProfile.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, PACKAGE_CLEANUP_FIELD, EXCLUDE_APP_PACKAGES_FROM_CLEANUP_FIELD, REBOOT_AFTER_USE_FIELD, NAME_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Boolean packageCleanup;
    private final List<String> excludeAppPackagesFromCleanup;
    private final Boolean rebootAfterUse;
    private final String name;
    private final String description;

    private InstanceProfile(BuilderImpl builder) {
        this.arn = builder.arn;
        this.packageCleanup = builder.packageCleanup;
        this.excludeAppPackagesFromCleanup = builder.excludeAppPackagesFromCleanup;
        this.rebootAfterUse = builder.rebootAfterUse;
        this.name = builder.name;
        this.description = builder.description;
    }

    public String arn() {
        return this.arn;
    }

    public Boolean packageCleanup() {
        return this.packageCleanup;
    }

    public boolean hasExcludeAppPackagesFromCleanup() {
        return this.excludeAppPackagesFromCleanup != null && !(this.excludeAppPackagesFromCleanup instanceof SdkAutoConstructList);
    }

    public List<String> excludeAppPackagesFromCleanup() {
        return this.excludeAppPackagesFromCleanup;
    }

    public Boolean rebootAfterUse() {
        return this.rebootAfterUse;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageCleanup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeAppPackagesFromCleanup() ? this.excludeAppPackagesFromCleanup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rebootAfterUse());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceProfile)) {
            return false;
        }
        InstanceProfile other = (InstanceProfile)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.packageCleanup(), other.packageCleanup()) && this.hasExcludeAppPackagesFromCleanup() == other.hasExcludeAppPackagesFromCleanup() && Objects.equals(this.excludeAppPackagesFromCleanup(), other.excludeAppPackagesFromCleanup()) && Objects.equals(this.rebootAfterUse(), other.rebootAfterUse()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"InstanceProfile").add("Arn", (Object)this.arn()).add("PackageCleanup", (Object)this.packageCleanup()).add("ExcludeAppPackagesFromCleanup", this.hasExcludeAppPackagesFromCleanup() ? this.excludeAppPackagesFromCleanup() : null).add("RebootAfterUse", (Object)this.rebootAfterUse()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "packageCleanup": {
                return Optional.ofNullable(clazz.cast(this.packageCleanup()));
            }
            case "excludeAppPackagesFromCleanup": {
                return Optional.ofNullable(clazz.cast(this.excludeAppPackagesFromCleanup()));
            }
            case "rebootAfterUse": {
                return Optional.ofNullable(clazz.cast(this.rebootAfterUse()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceProfile, T> g) {
        return obj -> g.apply((InstanceProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Boolean packageCleanup;
        private List<String> excludeAppPackagesFromCleanup = DefaultSdkAutoConstructList.getInstance();
        private Boolean rebootAfterUse;
        private String name;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceProfile model) {
            this.arn(model.arn);
            this.packageCleanup(model.packageCleanup);
            this.excludeAppPackagesFromCleanup(model.excludeAppPackagesFromCleanup);
            this.rebootAfterUse(model.rebootAfterUse);
            this.name(model.name);
            this.description(model.description);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Boolean getPackageCleanup() {
            return this.packageCleanup;
        }

        @Override
        public final Builder packageCleanup(Boolean packageCleanup) {
            this.packageCleanup = packageCleanup;
            return this;
        }

        public final void setPackageCleanup(Boolean packageCleanup) {
            this.packageCleanup = packageCleanup;
        }

        public final Collection<String> getExcludeAppPackagesFromCleanup() {
            if (this.excludeAppPackagesFromCleanup instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeAppPackagesFromCleanup;
        }

        @Override
        public final Builder excludeAppPackagesFromCleanup(Collection<String> excludeAppPackagesFromCleanup) {
            this.excludeAppPackagesFromCleanup = PackageIdsCopier.copy(excludeAppPackagesFromCleanup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeAppPackagesFromCleanup(String ... excludeAppPackagesFromCleanup) {
            this.excludeAppPackagesFromCleanup(Arrays.asList(excludeAppPackagesFromCleanup));
            return this;
        }

        public final void setExcludeAppPackagesFromCleanup(Collection<String> excludeAppPackagesFromCleanup) {
            this.excludeAppPackagesFromCleanup = PackageIdsCopier.copy(excludeAppPackagesFromCleanup);
        }

        public final Boolean getRebootAfterUse() {
            return this.rebootAfterUse;
        }

        @Override
        public final Builder rebootAfterUse(Boolean rebootAfterUse) {
            this.rebootAfterUse = rebootAfterUse;
            return this;
        }

        public final void setRebootAfterUse(Boolean rebootAfterUse) {
            this.rebootAfterUse = rebootAfterUse;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public InstanceProfile build() {
            return new InstanceProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceProfile> {
        public Builder arn(String var1);

        public Builder packageCleanup(Boolean var1);

        public Builder excludeAppPackagesFromCleanup(Collection<String> var1);

        public Builder excludeAppPackagesFromCleanup(String ... var1);

        public Builder rebootAfterUse(Boolean var1);

        public Builder name(String var1);

        public Builder description(String var1);
    }
}

