/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTestGridUrlResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, CreateTestGridUrlResponse> {
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(CreateTestGridUrlResponse.getter(CreateTestGridUrlResponse::url)).setter(CreateTestGridUrlResponse.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<Instant> EXPIRES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expires").getter(CreateTestGridUrlResponse.getter(CreateTestGridUrlResponse::expires)).setter(CreateTestGridUrlResponse.setter(Builder::expires)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expires").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, EXPIRES_FIELD));
    private final String url;
    private final Instant expires;

    private CreateTestGridUrlResponse(BuilderImpl builder) {
        super(builder);
        this.url = builder.url;
        this.expires = builder.expires;
    }

    public String url() {
        return this.url;
    }

    public Instant expires() {
        return this.expires;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.expires());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTestGridUrlResponse)) {
            return false;
        }
        CreateTestGridUrlResponse other = (CreateTestGridUrlResponse)((Object)obj);
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.expires(), other.expires());
    }

    public String toString() {
        return ToString.builder((String)"CreateTestGridUrlResponse").add("Url", (Object)this.url()).add("Expires", (Object)this.expires()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "expires": {
                return Optional.ofNullable(clazz.cast(this.expires()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTestGridUrlResponse, T> g) {
        return obj -> g.apply((CreateTestGridUrlResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private String url;
        private Instant expires;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTestGridUrlResponse model) {
            super(model);
            this.url(model.url);
            this.expires(model.expires);
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final Instant getExpires() {
            return this.expires;
        }

        @Override
        public final Builder expires(Instant expires) {
            this.expires = expires;
            return this;
        }

        public final void setExpires(Instant expires) {
            this.expires = expires;
        }

        @Override
        public CreateTestGridUrlResponse build() {
            return new CreateTestGridUrlResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTestGridUrlResponse> {
        public Builder url(String var1);

        public Builder expires(Instant var1);
    }
}

