/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.model.ListSuitesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse;
import software.amazon.awssdk.services.devicefarm.model.Suite;

public class ListSuitesPublisher
implements SdkPublisher<ListSuitesResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListSuitesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSuitesPublisher(DeviceFarmAsyncClient client, ListSuitesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSuitesPublisher(DeviceFarmAsyncClient client, ListSuitesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSuitesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSuitesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Suite> suites() {
        Function<ListSuitesResponse, Iterator> getIterator = response -> {
            if (response != null && response.suites() != null) {
                return response.suites().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSuitesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListSuitesPublisher resume(ListSuitesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSuitesPublisher(this.client, (ListSuitesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListSuitesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListSuitesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListSuitesResponseFetcher
    implements AsyncPageFetcher<ListSuitesResponse> {
        private ListSuitesResponseFetcher() {
        }

        public boolean hasNextPage(ListSuitesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSuitesResponse> nextPage(ListSuitesResponse previousPage) {
            if (previousPage == null) {
                return ListSuitesPublisher.this.client.listSuites(ListSuitesPublisher.this.firstRequest);
            }
            return ListSuitesPublisher.this.client.listSuites((ListSuitesRequest)((Object)ListSuitesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

