/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.NetworkProfileType;
import software.amazon.awssdk.services.devicefarm.transform.NetworkProfileMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NetworkProfile
implements StructuredPojo,
ToCopyableBuilder<Builder, NetworkProfile> {
    private final String arn;
    private final String name;
    private final String description;
    private final String type;
    private final Long uplinkBandwidthBits;
    private final Long downlinkBandwidthBits;
    private final Long uplinkDelayMs;
    private final Long downlinkDelayMs;
    private final Long uplinkJitterMs;
    private final Long downlinkJitterMs;
    private final Integer uplinkLossPercent;
    private final Integer downlinkLossPercent;

    private NetworkProfile(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.uplinkBandwidthBits = builder.uplinkBandwidthBits;
        this.downlinkBandwidthBits = builder.downlinkBandwidthBits;
        this.uplinkDelayMs = builder.uplinkDelayMs;
        this.downlinkDelayMs = builder.downlinkDelayMs;
        this.uplinkJitterMs = builder.uplinkJitterMs;
        this.downlinkJitterMs = builder.downlinkJitterMs;
        this.uplinkLossPercent = builder.uplinkLossPercent;
        this.downlinkLossPercent = builder.downlinkLossPercent;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public NetworkProfileType type() {
        return NetworkProfileType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Long uplinkBandwidthBits() {
        return this.uplinkBandwidthBits;
    }

    public Long downlinkBandwidthBits() {
        return this.downlinkBandwidthBits;
    }

    public Long uplinkDelayMs() {
        return this.uplinkDelayMs;
    }

    public Long downlinkDelayMs() {
        return this.downlinkDelayMs;
    }

    public Long uplinkJitterMs() {
        return this.uplinkJitterMs;
    }

    public Long downlinkJitterMs() {
        return this.downlinkJitterMs;
    }

    public Integer uplinkLossPercent() {
        return this.uplinkLossPercent;
    }

    public Integer downlinkLossPercent() {
        return this.downlinkLossPercent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uplinkBandwidthBits());
        hashCode = 31 * hashCode + Objects.hashCode(this.downlinkBandwidthBits());
        hashCode = 31 * hashCode + Objects.hashCode(this.uplinkDelayMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.downlinkDelayMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.uplinkJitterMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.downlinkJitterMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.uplinkLossPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.downlinkLossPercent());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkProfile)) {
            return false;
        }
        NetworkProfile other = (NetworkProfile)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.uplinkBandwidthBits(), other.uplinkBandwidthBits()) && Objects.equals(this.downlinkBandwidthBits(), other.downlinkBandwidthBits()) && Objects.equals(this.uplinkDelayMs(), other.uplinkDelayMs()) && Objects.equals(this.downlinkDelayMs(), other.downlinkDelayMs()) && Objects.equals(this.uplinkJitterMs(), other.uplinkJitterMs()) && Objects.equals(this.downlinkJitterMs(), other.downlinkJitterMs()) && Objects.equals(this.uplinkLossPercent(), other.uplinkLossPercent()) && Objects.equals(this.downlinkLossPercent(), other.downlinkLossPercent());
    }

    public String toString() {
        return ToString.builder((String)"NetworkProfile").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Type", (Object)this.typeString()).add("UplinkBandwidthBits", (Object)this.uplinkBandwidthBits()).add("DownlinkBandwidthBits", (Object)this.downlinkBandwidthBits()).add("UplinkDelayMs", (Object)this.uplinkDelayMs()).add("DownlinkDelayMs", (Object)this.downlinkDelayMs()).add("UplinkJitterMs", (Object)this.uplinkJitterMs()).add("DownlinkJitterMs", (Object)this.downlinkJitterMs()).add("UplinkLossPercent", (Object)this.uplinkLossPercent()).add("DownlinkLossPercent", (Object)this.downlinkLossPercent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "uplinkBandwidthBits": {
                return Optional.of(clazz.cast(this.uplinkBandwidthBits()));
            }
            case "downlinkBandwidthBits": {
                return Optional.of(clazz.cast(this.downlinkBandwidthBits()));
            }
            case "uplinkDelayMs": {
                return Optional.of(clazz.cast(this.uplinkDelayMs()));
            }
            case "downlinkDelayMs": {
                return Optional.of(clazz.cast(this.downlinkDelayMs()));
            }
            case "uplinkJitterMs": {
                return Optional.of(clazz.cast(this.uplinkJitterMs()));
            }
            case "downlinkJitterMs": {
                return Optional.of(clazz.cast(this.downlinkJitterMs()));
            }
            case "uplinkLossPercent": {
                return Optional.of(clazz.cast(this.uplinkLossPercent()));
            }
            case "downlinkLossPercent": {
                return Optional.of(clazz.cast(this.downlinkLossPercent()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkProfileMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private String type;
        private Long uplinkBandwidthBits;
        private Long downlinkBandwidthBits;
        private Long uplinkDelayMs;
        private Long downlinkDelayMs;
        private Long uplinkJitterMs;
        private Long downlinkJitterMs;
        private Integer uplinkLossPercent;
        private Integer downlinkLossPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkProfile model) {
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.type(model.type);
            this.uplinkBandwidthBits(model.uplinkBandwidthBits);
            this.downlinkBandwidthBits(model.downlinkBandwidthBits);
            this.uplinkDelayMs(model.uplinkDelayMs);
            this.downlinkDelayMs(model.downlinkDelayMs);
            this.uplinkJitterMs(model.uplinkJitterMs);
            this.downlinkJitterMs(model.downlinkJitterMs);
            this.uplinkLossPercent(model.uplinkLossPercent);
            this.downlinkLossPercent(model.downlinkLossPercent);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NetworkProfileType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Long getUplinkBandwidthBits() {
            return this.uplinkBandwidthBits;
        }

        @Override
        public final Builder uplinkBandwidthBits(Long uplinkBandwidthBits) {
            this.uplinkBandwidthBits = uplinkBandwidthBits;
            return this;
        }

        public final void setUplinkBandwidthBits(Long uplinkBandwidthBits) {
            this.uplinkBandwidthBits = uplinkBandwidthBits;
        }

        public final Long getDownlinkBandwidthBits() {
            return this.downlinkBandwidthBits;
        }

        @Override
        public final Builder downlinkBandwidthBits(Long downlinkBandwidthBits) {
            this.downlinkBandwidthBits = downlinkBandwidthBits;
            return this;
        }

        public final void setDownlinkBandwidthBits(Long downlinkBandwidthBits) {
            this.downlinkBandwidthBits = downlinkBandwidthBits;
        }

        public final Long getUplinkDelayMs() {
            return this.uplinkDelayMs;
        }

        @Override
        public final Builder uplinkDelayMs(Long uplinkDelayMs) {
            this.uplinkDelayMs = uplinkDelayMs;
            return this;
        }

        public final void setUplinkDelayMs(Long uplinkDelayMs) {
            this.uplinkDelayMs = uplinkDelayMs;
        }

        public final Long getDownlinkDelayMs() {
            return this.downlinkDelayMs;
        }

        @Override
        public final Builder downlinkDelayMs(Long downlinkDelayMs) {
            this.downlinkDelayMs = downlinkDelayMs;
            return this;
        }

        public final void setDownlinkDelayMs(Long downlinkDelayMs) {
            this.downlinkDelayMs = downlinkDelayMs;
        }

        public final Long getUplinkJitterMs() {
            return this.uplinkJitterMs;
        }

        @Override
        public final Builder uplinkJitterMs(Long uplinkJitterMs) {
            this.uplinkJitterMs = uplinkJitterMs;
            return this;
        }

        public final void setUplinkJitterMs(Long uplinkJitterMs) {
            this.uplinkJitterMs = uplinkJitterMs;
        }

        public final Long getDownlinkJitterMs() {
            return this.downlinkJitterMs;
        }

        @Override
        public final Builder downlinkJitterMs(Long downlinkJitterMs) {
            this.downlinkJitterMs = downlinkJitterMs;
            return this;
        }

        public final void setDownlinkJitterMs(Long downlinkJitterMs) {
            this.downlinkJitterMs = downlinkJitterMs;
        }

        public final Integer getUplinkLossPercent() {
            return this.uplinkLossPercent;
        }

        @Override
        public final Builder uplinkLossPercent(Integer uplinkLossPercent) {
            this.uplinkLossPercent = uplinkLossPercent;
            return this;
        }

        public final void setUplinkLossPercent(Integer uplinkLossPercent) {
            this.uplinkLossPercent = uplinkLossPercent;
        }

        public final Integer getDownlinkLossPercent() {
            return this.downlinkLossPercent;
        }

        @Override
        public final Builder downlinkLossPercent(Integer downlinkLossPercent) {
            this.downlinkLossPercent = downlinkLossPercent;
            return this;
        }

        public final void setDownlinkLossPercent(Integer downlinkLossPercent) {
            this.downlinkLossPercent = downlinkLossPercent;
        }

        public NetworkProfile build() {
            return new NetworkProfile(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkProfile> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(NetworkProfileType var1);

        public Builder uplinkBandwidthBits(Long var1);

        public Builder downlinkBandwidthBits(Long var1);

        public Builder uplinkDelayMs(Long var1);

        public Builder downlinkDelayMs(Long var1);

        public Builder uplinkJitterMs(Long var1);

        public Builder downlinkJitterMs(Long var1);

        public Builder uplinkLossPercent(Integer var1);

        public Builder downlinkLossPercent(Integer var1);
    }
}

