/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListTestsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestsResponse;
import software.amazon.awssdk.services.devicefarm.model.Test;

public final class ListTestsPaginator
implements SdkIterable<ListTestsResponse> {
    private final DeviceFarmClient client;
    private final ListTestsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListTestsPaginator(DeviceFarmClient client, ListTestsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTestsResponseFetcher();
    }

    public Iterator<ListTestsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Test> tests() {
        Function<ListTestsResponse, Iterator> getIterator = response -> response != null ? response.tests().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListTestsResponseFetcher
    implements NextPageFetcher<ListTestsResponse> {
        private ListTestsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListTestsResponse nextPage(ListTestsResponse previousPage) {
            if (previousPage == null) {
                return ListTestsPaginator.this.client.listTests(ListTestsPaginator.this.firstRequest);
            }
            return ListTestsPaginator.this.client.listTests((ListTestsRequest)((Object)ListTestsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

