/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListRunsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListRunsResponse;
import software.amazon.awssdk.services.devicefarm.model.Run;

public final class ListRunsPaginator
implements SdkIterable<ListRunsResponse> {
    private final DeviceFarmClient client;
    private final ListRunsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListRunsPaginator(DeviceFarmClient client, ListRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRunsResponseFetcher();
    }

    public Iterator<ListRunsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Run> runs() {
        Function<ListRunsResponse, Iterator> getIterator = response -> response != null ? response.runs().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListRunsResponseFetcher
    implements NextPageFetcher<ListRunsResponse> {
        private ListRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListRunsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListRunsResponse nextPage(ListRunsResponse previousPage) {
            if (previousPage == null) {
                return ListRunsPaginator.this.client.listRuns(ListRunsPaginator.this.firstRequest);
            }
            return ListRunsPaginator.this.client.listRuns((ListRunsRequest)((Object)ListRunsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

