/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.Device;
import software.amazon.awssdk.services.devicefarm.model.ListDevicesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse;

public final class ListDevicesPaginator
implements SdkIterable<ListDevicesResponse> {
    private final DeviceFarmClient client;
    private final ListDevicesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListDevicesPaginator(DeviceFarmClient client, ListDevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDevicesResponseFetcher();
    }

    public Iterator<ListDevicesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Device> devices() {
        Function<ListDevicesResponse, Iterator> getIterator = response -> response != null ? response.devices().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListDevicesResponseFetcher
    implements NextPageFetcher<ListDevicesResponse> {
        private ListDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListDevicesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListDevicesResponse nextPage(ListDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListDevicesPaginator.this.client.listDevices(ListDevicesPaginator.this.firstRequest);
            }
            return ListDevicesPaginator.this.client.listDevices((ListDevicesRequest)((Object)ListDevicesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

