/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.DevicePoolCompatibilityResult;
import software.amazon.awssdk.services.devicefarm.model.DevicePoolCompatibilityResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDevicePoolCompatibilityResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, GetDevicePoolCompatibilityResponse> {
    private final List<DevicePoolCompatibilityResult> compatibleDevices;
    private final List<DevicePoolCompatibilityResult> incompatibleDevices;

    private GetDevicePoolCompatibilityResponse(BuilderImpl builder) {
        super(builder);
        this.compatibleDevices = builder.compatibleDevices;
        this.incompatibleDevices = builder.incompatibleDevices;
    }

    public List<DevicePoolCompatibilityResult> compatibleDevices() {
        return this.compatibleDevices;
    }

    public List<DevicePoolCompatibilityResult> incompatibleDevices() {
        return this.incompatibleDevices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.compatibleDevices());
        hashCode = 31 * hashCode + Objects.hashCode(this.incompatibleDevices());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicePoolCompatibilityResponse)) {
            return false;
        }
        GetDevicePoolCompatibilityResponse other = (GetDevicePoolCompatibilityResponse)((Object)obj);
        return Objects.equals(this.compatibleDevices(), other.compatibleDevices()) && Objects.equals(this.incompatibleDevices(), other.incompatibleDevices());
    }

    public String toString() {
        return ToString.builder((String)"GetDevicePoolCompatibilityResponse").add("CompatibleDevices", this.compatibleDevices()).add("IncompatibleDevices", this.incompatibleDevices()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "compatibleDevices": {
                return Optional.of(clazz.cast(this.compatibleDevices()));
            }
            case "incompatibleDevices": {
                return Optional.of(clazz.cast(this.incompatibleDevices()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<DevicePoolCompatibilityResult> compatibleDevices;
        private List<DevicePoolCompatibilityResult> incompatibleDevices;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicePoolCompatibilityResponse model) {
            this.compatibleDevices(model.compatibleDevices);
            this.incompatibleDevices(model.incompatibleDevices);
        }

        public final Collection<DevicePoolCompatibilityResult.Builder> getCompatibleDevices() {
            return this.compatibleDevices != null ? (Collection)this.compatibleDevices.stream().map(DevicePoolCompatibilityResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder compatibleDevices(Collection<DevicePoolCompatibilityResult> compatibleDevices) {
            this.compatibleDevices = DevicePoolCompatibilityResultsCopier.copy(compatibleDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleDevices(DevicePoolCompatibilityResult ... compatibleDevices) {
            this.compatibleDevices(Arrays.asList(compatibleDevices));
            return this;
        }

        public final void setCompatibleDevices(Collection<DevicePoolCompatibilityResult.BuilderImpl> compatibleDevices) {
            this.compatibleDevices = DevicePoolCompatibilityResultsCopier.copyFromBuilder(compatibleDevices);
        }

        public final Collection<DevicePoolCompatibilityResult.Builder> getIncompatibleDevices() {
            return this.incompatibleDevices != null ? (Collection)this.incompatibleDevices.stream().map(DevicePoolCompatibilityResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder incompatibleDevices(Collection<DevicePoolCompatibilityResult> incompatibleDevices) {
            this.incompatibleDevices = DevicePoolCompatibilityResultsCopier.copy(incompatibleDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incompatibleDevices(DevicePoolCompatibilityResult ... incompatibleDevices) {
            this.incompatibleDevices(Arrays.asList(incompatibleDevices));
            return this;
        }

        public final void setIncompatibleDevices(Collection<DevicePoolCompatibilityResult.BuilderImpl> incompatibleDevices) {
            this.incompatibleDevices = DevicePoolCompatibilityResultsCopier.copyFromBuilder(incompatibleDevices);
        }

        @Override
        public GetDevicePoolCompatibilityResponse build() {
            return new GetDevicePoolCompatibilityResponse(this);
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    CopyableBuilder<Builder, GetDevicePoolCompatibilityResponse> {
        public Builder compatibleDevices(Collection<DevicePoolCompatibilityResult> var1);

        public Builder compatibleDevices(DevicePoolCompatibilityResult ... var1);

        public Builder incompatibleDevices(Collection<DevicePoolCompatibilityResult> var1);

        public Builder incompatibleDevices(DevicePoolCompatibilityResult ... var1);
    }
}

