/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeviceAttribute {
    ARN("ARN"),
    PLATFORM("PLATFORM"),
    FORM_FACTOR("FORM_FACTOR"),
    MANUFACTURER("MANUFACTURER"),
    REMOTE_ACCESS_ENABLED("REMOTE_ACCESS_ENABLED"),
    REMOTE_DEBUG_ENABLED("REMOTE_DEBUG_ENABLED"),
    APPIUM_VERSION("APPIUM_VERSION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeviceAttribute(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceAttribute fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeviceAttribute.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceAttribute> knownValues() {
        return Stream.of(DeviceAttribute.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

