/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.NetworkProfile;

@SdkInternalApi
public class NetworkProfileMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<Long> UPLINKBANDWIDTHBITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uplinkBandwidthBits").build();
    private static final MarshallingInfo<Long> DOWNLINKBANDWIDTHBITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("downlinkBandwidthBits").build();
    private static final MarshallingInfo<Long> UPLINKDELAYMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uplinkDelayMs").build();
    private static final MarshallingInfo<Long> DOWNLINKDELAYMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("downlinkDelayMs").build();
    private static final MarshallingInfo<Long> UPLINKJITTERMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uplinkJitterMs").build();
    private static final MarshallingInfo<Long> DOWNLINKJITTERMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("downlinkJitterMs").build();
    private static final MarshallingInfo<Integer> UPLINKLOSSPERCENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uplinkLossPercent").build();
    private static final MarshallingInfo<Integer> DOWNLINKLOSSPERCENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("downlinkLossPercent").build();
    private static final NetworkProfileMarshaller INSTANCE = new NetworkProfileMarshaller();

    public static NetworkProfileMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NetworkProfile networkProfile, ProtocolMarshaller protocolMarshaller) {
        if (networkProfile == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)networkProfile.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.uplinkBandwidthBits(), UPLINKBANDWIDTHBITS_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.downlinkBandwidthBits(), DOWNLINKBANDWIDTHBITS_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.uplinkDelayMs(), UPLINKDELAYMS_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.downlinkDelayMs(), DOWNLINKDELAYMS_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.uplinkJitterMs(), UPLINKJITTERMS_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.downlinkJitterMs(), DOWNLINKJITTERMS_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.uplinkLossPercent(), UPLINKLOSSPERCENT_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.downlinkLossPercent(), DOWNLINKLOSSPERCENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

