/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.Device;

@SdkInternalApi
public class DeviceMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> MANUFACTURER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("manufacturer").build();
    private static final MarshallingInfo<String> MODEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("model").build();
    private static final MarshallingInfo<String> FORMFACTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("formFactor").build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").build();
    private static final MarshallingInfo<String> OS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("os").build();
    private static final MarshallingInfo<StructuredPojo> CPU_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cpu").build();
    private static final MarshallingInfo<StructuredPojo> RESOLUTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resolution").build();
    private static final MarshallingInfo<Long> HEAPSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("heapSize").build();
    private static final MarshallingInfo<Long> MEMORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memory").build();
    private static final MarshallingInfo<String> IMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("image").build();
    private static final MarshallingInfo<String> CARRIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("carrier").build();
    private static final MarshallingInfo<String> RADIO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("radio").build();
    private static final MarshallingInfo<Boolean> REMOTEACCESSENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("remoteAccessEnabled").build();
    private static final MarshallingInfo<Boolean> REMOTEDEBUGENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("remoteDebugEnabled").build();
    private static final MarshallingInfo<String> FLEETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fleetType").build();
    private static final MarshallingInfo<String> FLEETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fleetName").build();
    private static final DeviceMarshaller INSTANCE = new DeviceMarshaller();

    public static DeviceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Device device, ProtocolMarshaller protocolMarshaller) {
        if (device == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)device.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)device.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)device.manufacturer(), MANUFACTURER_BINDING);
            protocolMarshaller.marshall((Object)device.model(), MODEL_BINDING);
            protocolMarshaller.marshall((Object)device.formFactorString(), FORMFACTOR_BINDING);
            protocolMarshaller.marshall((Object)device.platformString(), PLATFORM_BINDING);
            protocolMarshaller.marshall((Object)device.os(), OS_BINDING);
            protocolMarshaller.marshall((Object)device.cpu(), CPU_BINDING);
            protocolMarshaller.marshall((Object)device.resolution(), RESOLUTION_BINDING);
            protocolMarshaller.marshall((Object)device.heapSize(), HEAPSIZE_BINDING);
            protocolMarshaller.marshall((Object)device.memory(), MEMORY_BINDING);
            protocolMarshaller.marshall((Object)device.image(), IMAGE_BINDING);
            protocolMarshaller.marshall((Object)device.carrier(), CARRIER_BINDING);
            protocolMarshaller.marshall((Object)device.radio(), RADIO_BINDING);
            protocolMarshaller.marshall((Object)device.remoteAccessEnabled(), REMOTEACCESSENABLED_BINDING);
            protocolMarshaller.marshall((Object)device.remoteDebugEnabled(), REMOTEDEBUGENABLED_BINDING);
            protocolMarshaller.marshall((Object)device.fleetType(), FLEETTYPE_BINDING);
            protocolMarshaller.marshall((Object)device.fleetName(), FLEETNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

