/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse;
import software.amazon.awssdk.services.devicefarm.model.Sample;

public final class ListSamplesPaginator
implements SdkIterable<ListSamplesResponse> {
    private final DeviceFarmClient client;
    private final ListSamplesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListSamplesPaginator(DeviceFarmClient client, ListSamplesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSamplesResponseFetcher();
    }

    public Iterator<ListSamplesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Sample> samples() {
        Function<ListSamplesResponse, Iterator> getIterator = response -> response != null ? response.samples().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListSamplesResponseFetcher
    implements NextPageFetcher<ListSamplesResponse> {
        private ListSamplesResponseFetcher() {
        }

        public boolean hasNextPage(ListSamplesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListSamplesResponse nextPage(ListSamplesResponse previousPage) {
            if (previousPage == null) {
                return ListSamplesPaginator.this.client.listSamples(ListSamplesPaginator.this.firstRequest);
            }
            return ListSamplesPaginator.this.client.listSamples((ListSamplesRequest)((Object)ListSamplesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

