/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.Test;
import software.amazon.awssdk.services.devicefarm.model.TestsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTestsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListTestsResponse> {
    private final List<Test> tests;
    private final String nextToken;

    private ListTestsResponse(BuilderImpl builder) {
        super(builder);
        this.tests = builder.tests;
        this.nextToken = builder.nextToken;
    }

    public List<Test> tests() {
        return this.tests;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tests());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestsResponse)) {
            return false;
        }
        ListTestsResponse other = (ListTestsResponse)((Object)obj);
        return Objects.equals(this.tests(), other.tests()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tests() != null) {
            sb.append("Tests: ").append(this.tests()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tests": {
                return Optional.of(clazz.cast(this.tests()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<Test> tests;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestsResponse model) {
            this.tests(model.tests);
            this.nextToken(model.nextToken);
        }

        public final Collection<Test.Builder> getTests() {
            return this.tests != null ? (Collection)this.tests.stream().map(Test::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tests(Collection<Test> tests) {
            this.tests = TestsCopier.copy(tests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tests(Test ... tests) {
            this.tests(Arrays.asList(tests));
            return this;
        }

        public final void setTests(Collection<Test.BuilderImpl> tests) {
            this.tests = TestsCopier.copyFromBuilder(tests);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTestsResponse build() {
            return new ListTestsResponse(this);
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    CopyableBuilder<Builder, ListTestsResponse> {
        public Builder tests(Collection<Test> var1);

        public Builder tests(Test ... var1);

        public Builder nextToken(String var1);
    }
}

