/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.AndroidPathsCopier;
import software.amazon.awssdk.services.devicefarm.model.DeviceHostPathsCopier;
import software.amazon.awssdk.services.devicefarm.model.IosPathsCopier;
import software.amazon.awssdk.services.devicefarm.transform.CustomerArtifactPathsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CustomerArtifactPaths
implements StructuredPojo,
ToCopyableBuilder<Builder, CustomerArtifactPaths> {
    private final List<String> iosPaths;
    private final List<String> androidPaths;
    private final List<String> deviceHostPaths;

    private CustomerArtifactPaths(BuilderImpl builder) {
        this.iosPaths = builder.iosPaths;
        this.androidPaths = builder.androidPaths;
        this.deviceHostPaths = builder.deviceHostPaths;
    }

    public List<String> iosPaths() {
        return this.iosPaths;
    }

    public List<String> androidPaths() {
        return this.androidPaths;
    }

    public List<String> deviceHostPaths() {
        return this.deviceHostPaths;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iosPaths());
        hashCode = 31 * hashCode + Objects.hashCode(this.androidPaths());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceHostPaths());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerArtifactPaths)) {
            return false;
        }
        CustomerArtifactPaths other = (CustomerArtifactPaths)obj;
        return Objects.equals(this.iosPaths(), other.iosPaths()) && Objects.equals(this.androidPaths(), other.androidPaths()) && Objects.equals(this.deviceHostPaths(), other.deviceHostPaths());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.iosPaths() != null) {
            sb.append("IosPaths: ").append(this.iosPaths()).append(",");
        }
        if (this.androidPaths() != null) {
            sb.append("AndroidPaths: ").append(this.androidPaths()).append(",");
        }
        if (this.deviceHostPaths() != null) {
            sb.append("DeviceHostPaths: ").append(this.deviceHostPaths()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "iosPaths": {
                return Optional.of(clazz.cast(this.iosPaths()));
            }
            case "androidPaths": {
                return Optional.of(clazz.cast(this.androidPaths()));
            }
            case "deviceHostPaths": {
                return Optional.of(clazz.cast(this.deviceHostPaths()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomerArtifactPathsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> iosPaths;
        private List<String> androidPaths;
        private List<String> deviceHostPaths;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerArtifactPaths model) {
            this.iosPaths(model.iosPaths);
            this.androidPaths(model.androidPaths);
            this.deviceHostPaths(model.deviceHostPaths);
        }

        public final Collection<String> getIosPaths() {
            return this.iosPaths;
        }

        @Override
        public final Builder iosPaths(Collection<String> iosPaths) {
            this.iosPaths = IosPathsCopier.copy(iosPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iosPaths(String ... iosPaths) {
            this.iosPaths(Arrays.asList(iosPaths));
            return this;
        }

        public final void setIosPaths(Collection<String> iosPaths) {
            this.iosPaths = IosPathsCopier.copy(iosPaths);
        }

        public final Collection<String> getAndroidPaths() {
            return this.androidPaths;
        }

        @Override
        public final Builder androidPaths(Collection<String> androidPaths) {
            this.androidPaths = AndroidPathsCopier.copy(androidPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder androidPaths(String ... androidPaths) {
            this.androidPaths(Arrays.asList(androidPaths));
            return this;
        }

        public final void setAndroidPaths(Collection<String> androidPaths) {
            this.androidPaths = AndroidPathsCopier.copy(androidPaths);
        }

        public final Collection<String> getDeviceHostPaths() {
            return this.deviceHostPaths;
        }

        @Override
        public final Builder deviceHostPaths(Collection<String> deviceHostPaths) {
            this.deviceHostPaths = DeviceHostPathsCopier.copy(deviceHostPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceHostPaths(String ... deviceHostPaths) {
            this.deviceHostPaths(Arrays.asList(deviceHostPaths));
            return this;
        }

        public final void setDeviceHostPaths(Collection<String> deviceHostPaths) {
            this.deviceHostPaths = DeviceHostPathsCopier.copy(deviceHostPaths);
        }

        public CustomerArtifactPaths build() {
            return new CustomerArtifactPaths(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CustomerArtifactPaths> {
        public Builder iosPaths(Collection<String> var1);

        public Builder iosPaths(String ... var1);

        public Builder androidPaths(Collection<String> var1);

        public Builder androidPaths(String ... var1);

        public Builder deviceHostPaths(Collection<String> var1);

        public Builder deviceHostPaths(String ... var1);
    }
}

