/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.Counters;

@SdkInternalApi
public class CountersMarshaller {
    private static final MarshallingInfo<Integer> TOTAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("total").build();
    private static final MarshallingInfo<Integer> PASSED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("passed").build();
    private static final MarshallingInfo<Integer> FAILED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failed").build();
    private static final MarshallingInfo<Integer> WARNED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("warned").build();
    private static final MarshallingInfo<Integer> ERRORED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errored").build();
    private static final MarshallingInfo<Integer> STOPPED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stopped").build();
    private static final MarshallingInfo<Integer> SKIPPED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("skipped").build();
    private static final CountersMarshaller INSTANCE = new CountersMarshaller();

    public static CountersMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Counters counters, ProtocolMarshaller protocolMarshaller) {
        if (counters == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)counters.total(), TOTAL_BINDING);
            protocolMarshaller.marshall((Object)counters.passed(), PASSED_BINDING);
            protocolMarshaller.marshall((Object)counters.failed(), FAILED_BINDING);
            protocolMarshaller.marshall((Object)counters.warned(), WARNED_BINDING);
            protocolMarshaller.marshall((Object)counters.errored(), ERRORED_BINDING);
            protocolMarshaller.marshall((Object)counters.stopped(), STOPPED_BINDING);
            protocolMarshaller.marshall((Object)counters.skipped(), SKIPPED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

