/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionConfiguration;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateRemoteAccessSessionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateRemoteAccessSessionRequest> {
    private final String projectArn;
    private final String deviceArn;
    private final String name;
    private final CreateRemoteAccessSessionConfiguration configuration;

    private CreateRemoteAccessSessionRequest(BuilderImpl builder) {
        this.projectArn = builder.projectArn;
        this.deviceArn = builder.deviceArn;
        this.name = builder.name;
        this.configuration = builder.configuration;
    }

    public String projectArn() {
        return this.projectArn;
    }

    public String deviceArn() {
        return this.deviceArn;
    }

    public String name() {
        return this.name;
    }

    public CreateRemoteAccessSessionConfiguration configuration() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.projectArn() == null ? 0 : this.projectArn().hashCode());
        hashCode = 31 * hashCode + (this.deviceArn() == null ? 0 : this.deviceArn().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.configuration() == null ? 0 : this.configuration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRemoteAccessSessionRequest)) {
            return false;
        }
        CreateRemoteAccessSessionRequest other = (CreateRemoteAccessSessionRequest)((Object)obj);
        if (other.projectArn() == null ^ this.projectArn() == null) {
            return false;
        }
        if (other.projectArn() != null && !other.projectArn().equals(this.projectArn())) {
            return false;
        }
        if (other.deviceArn() == null ^ this.deviceArn() == null) {
            return false;
        }
        if (other.deviceArn() != null && !other.deviceArn().equals(this.deviceArn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.configuration() == null ^ this.configuration() == null) {
            return false;
        }
        return other.configuration() == null || other.configuration().equals(this.configuration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.projectArn() != null) {
            sb.append("ProjectArn: ").append(this.projectArn()).append(",");
        }
        if (this.deviceArn() != null) {
            sb.append("DeviceArn: ").append(this.deviceArn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.configuration() != null) {
            sb.append("Configuration: ").append(this.configuration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectArn": {
                return Optional.of(clazz.cast(this.projectArn()));
            }
            case "deviceArn": {
                return Optional.of(clazz.cast(this.deviceArn()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "configuration": {
                return Optional.of(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String projectArn;
        private String deviceArn;
        private String name;
        private CreateRemoteAccessSessionConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRemoteAccessSessionRequest model) {
            this.projectArn(model.projectArn);
            this.deviceArn(model.deviceArn);
            this.name(model.name);
            this.configuration(model.configuration);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final CreateRemoteAccessSessionConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(CreateRemoteAccessSessionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(CreateRemoteAccessSessionConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public CreateRemoteAccessSessionRequest build() {
            return new CreateRemoteAccessSessionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateRemoteAccessSessionRequest> {
        public Builder projectArn(String var1);

        public Builder deviceArn(String var1);

        public Builder name(String var1);

        public Builder configuration(CreateRemoteAccessSessionConfiguration var1);
    }
}

