/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.Device;
import software.amazon.awssdk.services.devicefarm.model.ExecutionResult;
import software.amazon.awssdk.services.devicefarm.model.ProblemDetail;
import software.amazon.awssdk.services.devicefarm.transform.ProblemMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Problem
implements StructuredPojo,
ToCopyableBuilder<Builder, Problem> {
    private final ProblemDetail run;
    private final ProblemDetail job;
    private final ProblemDetail suite;
    private final ProblemDetail test;
    private final Device device;
    private final String result;
    private final String message;

    private Problem(BuilderImpl builder) {
        this.run = builder.run;
        this.job = builder.job;
        this.suite = builder.suite;
        this.test = builder.test;
        this.device = builder.device;
        this.result = builder.result;
        this.message = builder.message;
    }

    public ProblemDetail run() {
        return this.run;
    }

    public ProblemDetail job() {
        return this.job;
    }

    public ProblemDetail suite() {
        return this.suite;
    }

    public ProblemDetail test() {
        return this.test;
    }

    public Device device() {
        return this.device;
    }

    public String result() {
        return this.result;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.run() == null ? 0 : this.run().hashCode());
        hashCode = 31 * hashCode + (this.job() == null ? 0 : this.job().hashCode());
        hashCode = 31 * hashCode + (this.suite() == null ? 0 : this.suite().hashCode());
        hashCode = 31 * hashCode + (this.test() == null ? 0 : this.test().hashCode());
        hashCode = 31 * hashCode + (this.device() == null ? 0 : this.device().hashCode());
        hashCode = 31 * hashCode + (this.result() == null ? 0 : this.result().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Problem)) {
            return false;
        }
        Problem other = (Problem)obj;
        if (other.run() == null ^ this.run() == null) {
            return false;
        }
        if (other.run() != null && !other.run().equals(this.run())) {
            return false;
        }
        if (other.job() == null ^ this.job() == null) {
            return false;
        }
        if (other.job() != null && !other.job().equals(this.job())) {
            return false;
        }
        if (other.suite() == null ^ this.suite() == null) {
            return false;
        }
        if (other.suite() != null && !other.suite().equals(this.suite())) {
            return false;
        }
        if (other.test() == null ^ this.test() == null) {
            return false;
        }
        if (other.test() != null && !other.test().equals(this.test())) {
            return false;
        }
        if (other.device() == null ^ this.device() == null) {
            return false;
        }
        if (other.device() != null && !other.device().equals(this.device())) {
            return false;
        }
        if (other.result() == null ^ this.result() == null) {
            return false;
        }
        if (other.result() != null && !other.result().equals(this.result())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        return other.message() == null || other.message().equals(this.message());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.run() != null) {
            sb.append("Run: ").append(this.run()).append(",");
        }
        if (this.job() != null) {
            sb.append("Job: ").append(this.job()).append(",");
        }
        if (this.suite() != null) {
            sb.append("Suite: ").append(this.suite()).append(",");
        }
        if (this.test() != null) {
            sb.append("Test: ").append(this.test()).append(",");
        }
        if (this.device() != null) {
            sb.append("Device: ").append(this.device()).append(",");
        }
        if (this.result() != null) {
            sb.append("Result: ").append(this.result()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProblemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private ProblemDetail run;
        private ProblemDetail job;
        private ProblemDetail suite;
        private ProblemDetail test;
        private Device device;
        private String result;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(Problem model) {
            this.setRun(model.run);
            this.setJob(model.job);
            this.setSuite(model.suite);
            this.setTest(model.test);
            this.setDevice(model.device);
            this.setResult(model.result);
            this.setMessage(model.message);
        }

        public final ProblemDetail getRun() {
            return this.run;
        }

        @Override
        public final Builder run(ProblemDetail run) {
            this.run = run;
            return this;
        }

        public final void setRun(ProblemDetail run) {
            this.run = run;
        }

        public final ProblemDetail getJob() {
            return this.job;
        }

        @Override
        public final Builder job(ProblemDetail job) {
            this.job = job;
            return this;
        }

        public final void setJob(ProblemDetail job) {
            this.job = job;
        }

        public final ProblemDetail getSuite() {
            return this.suite;
        }

        @Override
        public final Builder suite(ProblemDetail suite) {
            this.suite = suite;
            return this;
        }

        public final void setSuite(ProblemDetail suite) {
            this.suite = suite;
        }

        public final ProblemDetail getTest() {
            return this.test;
        }

        @Override
        public final Builder test(ProblemDetail test) {
            this.test = test;
            return this;
        }

        public final void setTest(ProblemDetail test) {
            this.test = test;
        }

        public final Device getDevice() {
            return this.device;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final void setDevice(Device device) {
            this.device = device;
        }

        public final String getResult() {
            return this.result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result.toString());
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public Problem build() {
            return new Problem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Problem> {
        public Builder run(ProblemDetail var1);

        public Builder job(ProblemDetail var1);

        public Builder suite(ProblemDetail var1);

        public Builder test(ProblemDetail var1);

        public Builder device(Device var1);

        public Builder result(String var1);

        public Builder result(ExecutionResult var1);

        public Builder message(String var1);
    }
}

