/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.devicefarm.model.Sample;
import software.amazon.awssdk.services.devicefarm.model.SamplesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListSamplesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListSamplesResponse> {
    private final List<Sample> samples;
    private final String nextToken;

    private ListSamplesResponse(BuilderImpl builder) {
        this.samples = builder.samples;
        this.nextToken = builder.nextToken;
    }

    public List<Sample> samples() {
        return this.samples;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.samples() == null ? 0 : this.samples().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSamplesResponse)) {
            return false;
        }
        ListSamplesResponse other = (ListSamplesResponse)((Object)obj);
        if (other.samples() == null ^ this.samples() == null) {
            return false;
        }
        if (other.samples() != null && !other.samples().equals(this.samples())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.samples() != null) {
            sb.append("Samples: ").append(this.samples()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Sample> samples;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSamplesResponse model) {
            this.setSamples(model.samples);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Sample> getSamples() {
            return this.samples;
        }

        @Override
        public final Builder samples(Collection<Sample> samples) {
            this.samples = SamplesCopier.copy(samples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samples(Sample ... samples) {
            this.samples(Arrays.asList(samples));
            return this;
        }

        public final void setSamples(Collection<Sample> samples) {
            this.samples = SamplesCopier.copy(samples);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListSamplesResponse build() {
            return new ListSamplesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListSamplesResponse> {
        public Builder samples(Collection<Sample> var1);

        public Builder samples(Sample ... var1);

        public Builder nextToken(String var1);
    }
}

