/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.devicefarm.model.Suite;
import software.amazon.awssdk.services.devicefarm.transform.CountersUnmarshaller;
import software.amazon.awssdk.services.devicefarm.transform.DeviceMinutesUnmarshaller;

public class SuiteUnmarshaller
implements Unmarshaller<Suite, JsonUnmarshallerContext> {
    private static SuiteUnmarshaller INSTANCE;

    public Suite unmarshall(JsonUnmarshallerContext context) throws Exception {
        Suite.Builder suiteBuilder = Suite.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    suiteBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    suiteBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("type", targetDepth)) {
                    context.nextToken();
                    suiteBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("created", targetDepth)) {
                    context.nextToken();
                    suiteBuilder.created((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    suiteBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("result", targetDepth)) {
                    context.nextToken();
                    suiteBuilder.result((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("started", targetDepth)) {
                    context.nextToken();
                    suiteBuilder.started((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("stopped", targetDepth)) {
                    context.nextToken();
                    suiteBuilder.stopped((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("counters", targetDepth)) {
                    context.nextToken();
                    suiteBuilder.counters(CountersUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("message", targetDepth)) {
                    context.nextToken();
                    suiteBuilder.message((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("deviceMinutes", targetDepth)) {
                    context.nextToken();
                    suiteBuilder.deviceMinutes(DeviceMinutesUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Suite)suiteBuilder.build();
    }

    public static SuiteUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SuiteUnmarshaller();
        }
        return INSTANCE;
    }
}

