/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.MonetaryAmount;
import software.amazon.awssdk.services.devicefarm.model.OfferingStatus;
import software.amazon.awssdk.services.devicefarm.transform.OfferingTransactionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OfferingTransaction
implements StructuredPojo,
ToCopyableBuilder<Builder, OfferingTransaction> {
    private final OfferingStatus offeringStatus;
    private final String transactionId;
    private final String offeringPromotionId;
    private final Instant createdOn;
    private final MonetaryAmount cost;

    private OfferingTransaction(BuilderImpl builder) {
        this.offeringStatus = builder.offeringStatus;
        this.transactionId = builder.transactionId;
        this.offeringPromotionId = builder.offeringPromotionId;
        this.createdOn = builder.createdOn;
        this.cost = builder.cost;
    }

    public OfferingStatus offeringStatus() {
        return this.offeringStatus;
    }

    public String transactionId() {
        return this.transactionId;
    }

    public String offeringPromotionId() {
        return this.offeringPromotionId;
    }

    public Instant createdOn() {
        return this.createdOn;
    }

    public MonetaryAmount cost() {
        return this.cost;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.offeringStatus() == null ? 0 : this.offeringStatus().hashCode());
        hashCode = 31 * hashCode + (this.transactionId() == null ? 0 : this.transactionId().hashCode());
        hashCode = 31 * hashCode + (this.offeringPromotionId() == null ? 0 : this.offeringPromotionId().hashCode());
        hashCode = 31 * hashCode + (this.createdOn() == null ? 0 : this.createdOn().hashCode());
        hashCode = 31 * hashCode + (this.cost() == null ? 0 : this.cost().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfferingTransaction)) {
            return false;
        }
        OfferingTransaction other = (OfferingTransaction)obj;
        if (other.offeringStatus() == null ^ this.offeringStatus() == null) {
            return false;
        }
        if (other.offeringStatus() != null && !other.offeringStatus().equals(this.offeringStatus())) {
            return false;
        }
        if (other.transactionId() == null ^ this.transactionId() == null) {
            return false;
        }
        if (other.transactionId() != null && !other.transactionId().equals(this.transactionId())) {
            return false;
        }
        if (other.offeringPromotionId() == null ^ this.offeringPromotionId() == null) {
            return false;
        }
        if (other.offeringPromotionId() != null && !other.offeringPromotionId().equals(this.offeringPromotionId())) {
            return false;
        }
        if (other.createdOn() == null ^ this.createdOn() == null) {
            return false;
        }
        if (other.createdOn() != null && !other.createdOn().equals(this.createdOn())) {
            return false;
        }
        if (other.cost() == null ^ this.cost() == null) {
            return false;
        }
        return other.cost() == null || other.cost().equals(this.cost());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.offeringStatus() != null) {
            sb.append("OfferingStatus: ").append(this.offeringStatus()).append(",");
        }
        if (this.transactionId() != null) {
            sb.append("TransactionId: ").append(this.transactionId()).append(",");
        }
        if (this.offeringPromotionId() != null) {
            sb.append("OfferingPromotionId: ").append(this.offeringPromotionId()).append(",");
        }
        if (this.createdOn() != null) {
            sb.append("CreatedOn: ").append(this.createdOn()).append(",");
        }
        if (this.cost() != null) {
            sb.append("Cost: ").append(this.cost()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OfferingTransactionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private OfferingStatus offeringStatus;
        private String transactionId;
        private String offeringPromotionId;
        private Instant createdOn;
        private MonetaryAmount cost;

        private BuilderImpl() {
        }

        private BuilderImpl(OfferingTransaction model) {
            this.setOfferingStatus(model.offeringStatus);
            this.setTransactionId(model.transactionId);
            this.setOfferingPromotionId(model.offeringPromotionId);
            this.setCreatedOn(model.createdOn);
            this.setCost(model.cost);
        }

        public final OfferingStatus getOfferingStatus() {
            return this.offeringStatus;
        }

        @Override
        public final Builder offeringStatus(OfferingStatus offeringStatus) {
            this.offeringStatus = offeringStatus;
            return this;
        }

        public final void setOfferingStatus(OfferingStatus offeringStatus) {
            this.offeringStatus = offeringStatus;
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        public final String getOfferingPromotionId() {
            return this.offeringPromotionId;
        }

        @Override
        public final Builder offeringPromotionId(String offeringPromotionId) {
            this.offeringPromotionId = offeringPromotionId;
            return this;
        }

        public final void setOfferingPromotionId(String offeringPromotionId) {
            this.offeringPromotionId = offeringPromotionId;
        }

        public final Instant getCreatedOn() {
            return this.createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        public final MonetaryAmount getCost() {
            return this.cost;
        }

        @Override
        public final Builder cost(MonetaryAmount cost) {
            this.cost = cost;
            return this;
        }

        public final void setCost(MonetaryAmount cost) {
            this.cost = cost;
        }

        public OfferingTransaction build() {
            return new OfferingTransaction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OfferingTransaction> {
        public Builder offeringStatus(OfferingStatus var1);

        public Builder transactionId(String var1);

        public Builder offeringPromotionId(String var1);

        public Builder createdOn(Instant var1);

        public Builder cost(MonetaryAmount var1);
    }
}

