/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.devicefarm.model.Run;
import software.amazon.awssdk.services.devicefarm.model.RunsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRunsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListRunsResponse> {
    private final List<Run> runs;
    private final String nextToken;

    private ListRunsResponse(BuilderImpl builder) {
        this.runs = builder.runs;
        this.nextToken = builder.nextToken;
    }

    public List<Run> runs() {
        return this.runs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.runs() == null ? 0 : this.runs().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRunsResponse)) {
            return false;
        }
        ListRunsResponse other = (ListRunsResponse)((Object)obj);
        if (other.runs() == null ^ this.runs() == null) {
            return false;
        }
        if (other.runs() != null && !other.runs().equals(this.runs())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.runs() != null) {
            sb.append("Runs: ").append(this.runs()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Run> runs;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRunsResponse model) {
            this.setRuns(model.runs);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Run> getRuns() {
            return this.runs;
        }

        @Override
        public final Builder runs(Collection<Run> runs) {
            this.runs = RunsCopier.copy(runs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runs(Run ... runs) {
            this.runs(Arrays.asList(runs));
            return this;
        }

        public final void setRuns(Collection<Run> runs) {
            this.runs = RunsCopier.copy(runs);
        }

        @SafeVarargs
        public final void setRuns(Run ... runs) {
            this.runs(Arrays.asList(runs));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListRunsResponse build() {
            return new ListRunsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListRunsResponse> {
        public Builder runs(Collection<Run> var1);

        public Builder runs(Run ... var1);

        public Builder nextToken(String var1);
    }
}

