/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.NetworkProfile;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NetworkProfileMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<Long> UPLINKBANDWIDTHBITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uplinkBandwidthBits").isBinary(false).build();
    private static final MarshallingInfo<Long> DOWNLINKBANDWIDTHBITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("downlinkBandwidthBits").isBinary(false).build();
    private static final MarshallingInfo<Long> UPLINKDELAYMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uplinkDelayMs").isBinary(false).build();
    private static final MarshallingInfo<Long> DOWNLINKDELAYMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("downlinkDelayMs").isBinary(false).build();
    private static final MarshallingInfo<Long> UPLINKJITTERMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uplinkJitterMs").isBinary(false).build();
    private static final MarshallingInfo<Long> DOWNLINKJITTERMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("downlinkJitterMs").isBinary(false).build();
    private static final MarshallingInfo<Integer> UPLINKLOSSPERCENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uplinkLossPercent").isBinary(false).build();
    private static final MarshallingInfo<Integer> DOWNLINKLOSSPERCENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("downlinkLossPercent").isBinary(false).build();
    private static final NetworkProfileMarshaller INSTANCE = new NetworkProfileMarshaller();

    private NetworkProfileMarshaller() {
    }

    public static NetworkProfileMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NetworkProfile networkProfile, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)networkProfile, (String)"networkProfile");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)networkProfile.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.uplinkBandwidthBits(), UPLINKBANDWIDTHBITS_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.downlinkBandwidthBits(), DOWNLINKBANDWIDTHBITS_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.uplinkDelayMs(), UPLINKDELAYMS_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.downlinkDelayMs(), DOWNLINKDELAYMS_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.uplinkJitterMs(), UPLINKJITTERMS_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.downlinkJitterMs(), DOWNLINKJITTERMS_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.uplinkLossPercent(), UPLINKLOSSPERCENT_BINDING);
            protocolMarshaller.marshall((Object)networkProfile.downlinkLossPercent(), DOWNLINKLOSSPERCENT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

