/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.Counters;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CountersMarshaller {
    private static final MarshallingInfo<Integer> TOTAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("total").isBinary(false).build();
    private static final MarshallingInfo<Integer> PASSED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("passed").isBinary(false).build();
    private static final MarshallingInfo<Integer> FAILED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failed").isBinary(false).build();
    private static final MarshallingInfo<Integer> WARNED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("warned").isBinary(false).build();
    private static final MarshallingInfo<Integer> ERRORED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errored").isBinary(false).build();
    private static final MarshallingInfo<Integer> STOPPED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stopped").isBinary(false).build();
    private static final MarshallingInfo<Integer> SKIPPED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("skipped").isBinary(false).build();
    private static final CountersMarshaller INSTANCE = new CountersMarshaller();

    private CountersMarshaller() {
    }

    public static CountersMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Counters counters, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)counters, (String)"counters");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)counters.total(), TOTAL_BINDING);
            protocolMarshaller.marshall((Object)counters.passed(), PASSED_BINDING);
            protocolMarshaller.marshall((Object)counters.failed(), FAILED_BINDING);
            protocolMarshaller.marshall((Object)counters.warned(), WARNED_BINDING);
            protocolMarshaller.marshall((Object)counters.errored(), ERRORED_BINDING);
            protocolMarshaller.marshall((Object)counters.stopped(), STOPPED_BINDING);
            protocolMarshaller.marshall((Object)counters.skipped(), SKIPPED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

