/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.services.devicefarm.model.InstanceLabelsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDeviceInstanceRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, UpdateDeviceInstanceRequest> {
    private final String arn;
    private final String profileArn;
    private final List<String> labels;

    private UpdateDeviceInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.profileArn = builder.profileArn;
        this.labels = builder.labels;
    }

    public String arn() {
        return this.arn;
    }

    public String profileArn() {
        return this.profileArn;
    }

    public List<String> labels() {
        return this.labels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.labels());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeviceInstanceRequest)) {
            return false;
        }
        UpdateDeviceInstanceRequest other = (UpdateDeviceInstanceRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.profileArn(), other.profileArn()) && Objects.equals(this.labels(), other.labels());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDeviceInstanceRequest").add("Arn", (Object)this.arn()).add("ProfileArn", (Object)this.profileArn()).add("Labels", this.labels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "profileArn": {
                return Optional.ofNullable(clazz.cast(this.profileArn()));
            }
            case "labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String arn;
        private String profileArn;
        private List<String> labels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeviceInstanceRequest model) {
            super(model);
            this.arn(model.arn);
            this.profileArn(model.profileArn);
            this.labels(model.labels);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getProfileArn() {
            return this.profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        public final Collection<String> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = InstanceLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = InstanceLabelsCopier.copy(labels);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDeviceInstanceRequest build() {
            return new UpdateDeviceInstanceRequest(this);
        }
    }

    public static interface Builder
    extends DeviceFarmRequest.Builder,
    CopyableBuilder<Builder, UpdateDeviceInstanceRequest> {
        public Builder arn(String var1);

        public Builder profileArn(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

