/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.AmazonResourceNamesCopier;
import software.amazon.awssdk.services.devicefarm.model.BillingMethod;
import software.amazon.awssdk.services.devicefarm.transform.CreateRemoteAccessSessionConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRemoteAccessSessionConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, CreateRemoteAccessSessionConfiguration> {
    private final String billingMethod;
    private final List<String> vpceConfigurationArns;

    private CreateRemoteAccessSessionConfiguration(BuilderImpl builder) {
        this.billingMethod = builder.billingMethod;
        this.vpceConfigurationArns = builder.vpceConfigurationArns;
    }

    public BillingMethod billingMethod() {
        return BillingMethod.fromValue(this.billingMethod);
    }

    public String billingMethodAsString() {
        return this.billingMethod;
    }

    public List<String> vpceConfigurationArns() {
        return this.vpceConfigurationArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.billingMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpceConfigurationArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRemoteAccessSessionConfiguration)) {
            return false;
        }
        CreateRemoteAccessSessionConfiguration other = (CreateRemoteAccessSessionConfiguration)obj;
        return Objects.equals(this.billingMethodAsString(), other.billingMethodAsString()) && Objects.equals(this.vpceConfigurationArns(), other.vpceConfigurationArns());
    }

    public String toString() {
        return ToString.builder((String)"CreateRemoteAccessSessionConfiguration").add("BillingMethod", (Object)this.billingMethodAsString()).add("VpceConfigurationArns", this.vpceConfigurationArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "billingMethod": {
                return Optional.ofNullable(clazz.cast(this.billingMethodAsString()));
            }
            case "vpceConfigurationArns": {
                return Optional.ofNullable(clazz.cast(this.vpceConfigurationArns()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CreateRemoteAccessSessionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String billingMethod;
        private List<String> vpceConfigurationArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRemoteAccessSessionConfiguration model) {
            this.billingMethod(model.billingMethod);
            this.vpceConfigurationArns(model.vpceConfigurationArns);
        }

        public final String getBillingMethod() {
            return this.billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod.toString());
            return this;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        public final Collection<String> getVpceConfigurationArns() {
            return this.vpceConfigurationArns;
        }

        @Override
        public final Builder vpceConfigurationArns(Collection<String> vpceConfigurationArns) {
            this.vpceConfigurationArns = AmazonResourceNamesCopier.copy(vpceConfigurationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpceConfigurationArns(String ... vpceConfigurationArns) {
            this.vpceConfigurationArns(Arrays.asList(vpceConfigurationArns));
            return this;
        }

        public final void setVpceConfigurationArns(Collection<String> vpceConfigurationArns) {
            this.vpceConfigurationArns = AmazonResourceNamesCopier.copy(vpceConfigurationArns);
        }

        public CreateRemoteAccessSessionConfiguration build() {
            return new CreateRemoteAccessSessionConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateRemoteAccessSessionConfiguration> {
        public Builder billingMethod(String var1);

        public Builder billingMethod(BillingMethod var1);

        public Builder vpceConfigurationArns(Collection<String> var1);

        public Builder vpceConfigurationArns(String ... var1);
    }
}

