/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.ArtifactType;
import software.amazon.awssdk.services.devicefarm.transform.ArtifactMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Artifact
implements StructuredPojo,
ToCopyableBuilder<Builder, Artifact> {
    private final String arn;
    private final String name;
    private final String type;
    private final String extension;
    private final String url;

    private Artifact(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.extension = builder.extension;
        this.url = builder.url;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public ArtifactType type() {
        return ArtifactType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String extension() {
        return this.extension;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.extension());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Artifact)) {
            return false;
        }
        Artifact other = (Artifact)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.extension(), other.extension()) && Objects.equals(this.url(), other.url());
    }

    public String toString() {
        return ToString.builder((String)"Artifact").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Extension", (Object)this.extension()).add("Url", (Object)this.url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "extension": {
                return Optional.ofNullable(clazz.cast(this.extension()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ArtifactMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String type;
        private String extension;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(Artifact model) {
            this.arn(model.arn);
            this.name(model.name);
            this.type(model.type);
            this.extension(model.extension);
            this.url(model.url);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ArtifactType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getExtension() {
            return this.extension;
        }

        @Override
        public final Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public final void setExtension(String extension) {
            this.extension = extension;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public Artifact build() {
            return new Artifact(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Artifact> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ArtifactType var1);

        public Builder extension(String var1);

        public Builder url(String var1);
    }
}

