/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.Run;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RunMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("created").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<String> RESULT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("result").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("started").isBinary(false).build();
    private static final MarshallingInfo<Instant> STOPPED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stopped").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COUNTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("counters").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").isBinary(false).build();
    private static final MarshallingInfo<Integer> TOTALJOBS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalJobs").isBinary(false).build();
    private static final MarshallingInfo<Integer> COMPLETEDJOBS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("completedJobs").isBinary(false).build();
    private static final MarshallingInfo<String> BILLINGMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("billingMethod").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DEVICEMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deviceMinutes").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NETWORKPROFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networkProfile").isBinary(false).build();
    private static final MarshallingInfo<String> PARSINGRESULTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parsingResultUrl").isBinary(false).build();
    private static final MarshallingInfo<String> RESULTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resultCode").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CUSTOMERARTIFACTPATHS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerArtifactPaths").isBinary(false).build();
    private static final RunMarshaller INSTANCE = new RunMarshaller();

    private RunMarshaller() {
    }

    public static RunMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Run run, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)run, (String)"run");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)run.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)run.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)run.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)run.platformAsString(), PLATFORM_BINDING);
            protocolMarshaller.marshall((Object)run.created(), CREATED_BINDING);
            protocolMarshaller.marshall((Object)run.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)run.resultAsString(), RESULT_BINDING);
            protocolMarshaller.marshall((Object)run.started(), STARTED_BINDING);
            protocolMarshaller.marshall((Object)run.stopped(), STOPPED_BINDING);
            protocolMarshaller.marshall((Object)run.counters(), COUNTERS_BINDING);
            protocolMarshaller.marshall((Object)run.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)run.totalJobs(), TOTALJOBS_BINDING);
            protocolMarshaller.marshall((Object)run.completedJobs(), COMPLETEDJOBS_BINDING);
            protocolMarshaller.marshall((Object)run.billingMethodAsString(), BILLINGMETHOD_BINDING);
            protocolMarshaller.marshall((Object)run.deviceMinutes(), DEVICEMINUTES_BINDING);
            protocolMarshaller.marshall((Object)run.networkProfile(), NETWORKPROFILE_BINDING);
            protocolMarshaller.marshall((Object)run.parsingResultUrl(), PARSINGRESULTURL_BINDING);
            protocolMarshaller.marshall((Object)run.resultCodeAsString(), RESULTCODE_BINDING);
            protocolMarshaller.marshall((Object)run.customerArtifactPaths(), CUSTOMERARTIFACTPATHS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

