/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.Job;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("created").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<String> RESULT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("result").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("started").isBinary(false).build();
    private static final MarshallingInfo<Instant> STOPPED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stopped").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COUNTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("counters").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("device").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DEVICEMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deviceMinutes").isBinary(false).build();
    private static final JobMarshaller INSTANCE = new JobMarshaller();

    private JobMarshaller() {
    }

    public static JobMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Job job, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)job, (String)"job");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)job.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)job.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)job.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)job.created(), CREATED_BINDING);
            protocolMarshaller.marshall((Object)job.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)job.resultAsString(), RESULT_BINDING);
            protocolMarshaller.marshall((Object)job.started(), STARTED_BINDING);
            protocolMarshaller.marshall((Object)job.stopped(), STOPPED_BINDING);
            protocolMarshaller.marshall((Object)job.counters(), COUNTERS_BINDING);
            protocolMarshaller.marshall((Object)job.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)job.device(), DEVICE_BINDING);
            protocolMarshaller.marshall((Object)job.deviceMinutes(), DEVICEMINUTES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

