/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse;
import software.amazon.awssdk.services.devicefarm.model.UniqueProblem;

public class ListUniqueProblemsIterable
implements SdkIterable<ListUniqueProblemsResponse> {
    private final DeviceFarmClient client;
    private final ListUniqueProblemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUniqueProblemsIterable(DeviceFarmClient client, ListUniqueProblemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListUniqueProblemsResponseFetcher();
    }

    public Iterator<ListUniqueProblemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Map.Entry<String, List<UniqueProblem>>> uniqueProblemsAsStrings() {
        Function<ListUniqueProblemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.uniqueProblemsAsStrings() != null) {
                return response.uniqueProblemsAsStrings().entrySet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListUniqueProblemsIterable resume(ListUniqueProblemsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListUniqueProblemsIterable(this.client, (ListUniqueProblemsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListUniqueProblemsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListUniqueProblemsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListUniqueProblemsResponseFetcher
    implements SyncPageFetcher<ListUniqueProblemsResponse> {
        private ListUniqueProblemsResponseFetcher() {
        }

        public boolean hasNextPage(ListUniqueProblemsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListUniqueProblemsResponse nextPage(ListUniqueProblemsResponse previousPage) {
            if (previousPage == null) {
                return ListUniqueProblemsIterable.this.client.listUniqueProblems(ListUniqueProblemsIterable.this.firstRequest);
            }
            return ListUniqueProblemsIterable.this.client.listUniqueProblems((ListUniqueProblemsRequest)((Object)ListUniqueProblemsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

