/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListSamplesRequest;
import software.amazon.awssdk.services.devicefarm.model.ListSamplesResponse;
import software.amazon.awssdk.services.devicefarm.model.Sample;

public class ListSamplesIterable
implements SdkIterable<ListSamplesResponse> {
    private final DeviceFarmClient client;
    private final ListSamplesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSamplesIterable(DeviceFarmClient client, ListSamplesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSamplesResponseFetcher();
    }

    public Iterator<ListSamplesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Sample> samples() {
        Function<ListSamplesResponse, Iterator> getIterator = response -> {
            if (response != null && response.samples() != null) {
                return response.samples().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListSamplesIterable resume(ListSamplesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSamplesIterable(this.client, (ListSamplesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListSamplesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListSamplesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListSamplesResponseFetcher
    implements SyncPageFetcher<ListSamplesResponse> {
        private ListSamplesResponseFetcher() {
        }

        public boolean hasNextPage(ListSamplesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListSamplesResponse nextPage(ListSamplesResponse previousPage) {
            if (previousPage == null) {
                return ListSamplesIterable.this.client.listSamples(ListSamplesIterable.this.firstRequest);
            }
            return ListSamplesIterable.this.client.listSamples((ListSamplesRequest)((Object)ListSamplesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

