/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.model.ListProjectsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse;
import software.amazon.awssdk.services.devicefarm.model.Project;

public class ListProjectsPublisher
implements SdkPublisher<ListProjectsResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListProjectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProjectsPublisher(DeviceFarmAsyncClient client, ListProjectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProjectsPublisher(DeviceFarmAsyncClient client, ListProjectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProjectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProjectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Project> projects() {
        Function<ListProjectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.projects() != null) {
                return response.projects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProjectsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListProjectsPublisher resume(ListProjectsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListProjectsPublisher(this.client, (ListProjectsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListProjectsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListProjectsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListProjectsResponseFetcher
    implements AsyncPageFetcher<ListProjectsResponse> {
        private ListProjectsResponseFetcher() {
        }

        public boolean hasNextPage(ListProjectsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<ListProjectsResponse> nextPage(ListProjectsResponse previousPage) {
            if (previousPage == null) {
                return ListProjectsPublisher.this.client.listProjects(ListProjectsPublisher.this.firstRequest);
            }
            return ListProjectsPublisher.this.client.listProjects((ListProjectsRequest)((Object)ListProjectsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

