/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.UploadStatus;
import software.amazon.awssdk.services.devicefarm.model.UploadType;
import software.amazon.awssdk.services.devicefarm.transform.UploadMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Upload
implements StructuredPojo,
ToCopyableBuilder<Builder, Upload> {
    private final String arn;
    private final String name;
    private final Instant created;
    private final String type;
    private final String status;
    private final String url;
    private final String metadata;
    private final String contentType;
    private final String message;

    private Upload(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.created = builder.created;
        this.type = builder.type;
        this.status = builder.status;
        this.url = builder.url;
        this.metadata = builder.metadata;
        this.contentType = builder.contentType;
        this.message = builder.message;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public Instant created() {
        return this.created;
    }

    public UploadType type() {
        return UploadType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public UploadStatus status() {
        return UploadStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String url() {
        return this.url;
    }

    public String metadata() {
        return this.metadata;
    }

    public String contentType() {
        return this.contentType;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Upload)) {
            return false;
        }
        Upload other = (Upload)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.message(), other.message());
    }

    public String toString() {
        return ToString.builder((String)"Upload").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Created", (Object)this.created()).add("Type", (Object)this.typeAsString()).add("Status", (Object)this.statusAsString()).add("Url", (Object)this.url()).add("Metadata", (Object)this.metadata()).add("ContentType", (Object)this.contentType()).add("Message", (Object)this.message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UploadMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private Instant created;
        private String type;
        private String status;
        private String url;
        private String metadata;
        private String contentType;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(Upload model) {
            this.arn(model.arn);
            this.name(model.name);
            this.created(model.created);
            this.type(model.type);
            this.status(model.status);
            this.url(model.url);
            this.metadata(model.metadata);
            this.contentType(model.contentType);
            this.message(model.message);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UploadType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UploadStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public Upload build() {
            return new Upload(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Upload> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder created(Instant var1);

        public Builder type(String var1);

        public Builder type(UploadType var1);

        public Builder status(String var1);

        public Builder status(UploadStatus var1);

        public Builder url(String var1);

        public Builder metadata(String var1);

        public Builder contentType(String var1);

        public Builder message(String var1);
    }
}

