/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.AmazonResourceNamesCopier;
import software.amazon.awssdk.services.devicefarm.model.BillingMethod;
import software.amazon.awssdk.services.devicefarm.model.CustomerArtifactPaths;
import software.amazon.awssdk.services.devicefarm.model.Location;
import software.amazon.awssdk.services.devicefarm.model.Radios;
import software.amazon.awssdk.services.devicefarm.transform.ScheduleRunConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduleRunConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, ScheduleRunConfiguration> {
    private final String extraDataPackageArn;
    private final String networkProfileArn;
    private final String locale;
    private final Location location;
    private final CustomerArtifactPaths customerArtifactPaths;
    private final Radios radios;
    private final List<String> auxiliaryApps;
    private final String billingMethod;

    private ScheduleRunConfiguration(BuilderImpl builder) {
        this.extraDataPackageArn = builder.extraDataPackageArn;
        this.networkProfileArn = builder.networkProfileArn;
        this.locale = builder.locale;
        this.location = builder.location;
        this.customerArtifactPaths = builder.customerArtifactPaths;
        this.radios = builder.radios;
        this.auxiliaryApps = builder.auxiliaryApps;
        this.billingMethod = builder.billingMethod;
    }

    public String extraDataPackageArn() {
        return this.extraDataPackageArn;
    }

    public String networkProfileArn() {
        return this.networkProfileArn;
    }

    public String locale() {
        return this.locale;
    }

    public Location location() {
        return this.location;
    }

    public CustomerArtifactPaths customerArtifactPaths() {
        return this.customerArtifactPaths;
    }

    public Radios radios() {
        return this.radios;
    }

    public List<String> auxiliaryApps() {
        return this.auxiliaryApps;
    }

    public BillingMethod billingMethod() {
        return BillingMethod.fromValue(this.billingMethod);
    }

    public String billingMethodAsString() {
        return this.billingMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.extraDataPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerArtifactPaths());
        hashCode = 31 * hashCode + Objects.hashCode(this.radios());
        hashCode = 31 * hashCode + Objects.hashCode(this.auxiliaryApps());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingMethodAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleRunConfiguration)) {
            return false;
        }
        ScheduleRunConfiguration other = (ScheduleRunConfiguration)obj;
        return Objects.equals(this.extraDataPackageArn(), other.extraDataPackageArn()) && Objects.equals(this.networkProfileArn(), other.networkProfileArn()) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.customerArtifactPaths(), other.customerArtifactPaths()) && Objects.equals(this.radios(), other.radios()) && Objects.equals(this.auxiliaryApps(), other.auxiliaryApps()) && Objects.equals(this.billingMethodAsString(), other.billingMethodAsString());
    }

    public String toString() {
        return ToString.builder((String)"ScheduleRunConfiguration").add("ExtraDataPackageArn", (Object)this.extraDataPackageArn()).add("NetworkProfileArn", (Object)this.networkProfileArn()).add("Locale", (Object)this.locale()).add("Location", (Object)this.location()).add("CustomerArtifactPaths", (Object)this.customerArtifactPaths()).add("Radios", (Object)this.radios()).add("AuxiliaryApps", this.auxiliaryApps()).add("BillingMethod", (Object)this.billingMethodAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "extraDataPackageArn": {
                return Optional.ofNullable(clazz.cast(this.extraDataPackageArn()));
            }
            case "networkProfileArn": {
                return Optional.ofNullable(clazz.cast(this.networkProfileArn()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "customerArtifactPaths": {
                return Optional.ofNullable(clazz.cast(this.customerArtifactPaths()));
            }
            case "radios": {
                return Optional.ofNullable(clazz.cast(this.radios()));
            }
            case "auxiliaryApps": {
                return Optional.ofNullable(clazz.cast(this.auxiliaryApps()));
            }
            case "billingMethod": {
                return Optional.ofNullable(clazz.cast(this.billingMethodAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduleRunConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String extraDataPackageArn;
        private String networkProfileArn;
        private String locale;
        private Location location;
        private CustomerArtifactPaths customerArtifactPaths;
        private Radios radios;
        private List<String> auxiliaryApps = DefaultSdkAutoConstructList.getInstance();
        private String billingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleRunConfiguration model) {
            this.extraDataPackageArn(model.extraDataPackageArn);
            this.networkProfileArn(model.networkProfileArn);
            this.locale(model.locale);
            this.location(model.location);
            this.customerArtifactPaths(model.customerArtifactPaths);
            this.radios(model.radios);
            this.auxiliaryApps(model.auxiliaryApps);
            this.billingMethod(model.billingMethod);
        }

        public final String getExtraDataPackageArn() {
            return this.extraDataPackageArn;
        }

        @Override
        public final Builder extraDataPackageArn(String extraDataPackageArn) {
            this.extraDataPackageArn = extraDataPackageArn;
            return this;
        }

        public final void setExtraDataPackageArn(String extraDataPackageArn) {
            this.extraDataPackageArn = extraDataPackageArn;
        }

        public final String getNetworkProfileArn() {
            return this.networkProfileArn;
        }

        @Override
        public final Builder networkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
            return this;
        }

        public final void setNetworkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final Location.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final CustomerArtifactPaths.Builder getCustomerArtifactPaths() {
            return this.customerArtifactPaths != null ? this.customerArtifactPaths.toBuilder() : null;
        }

        @Override
        public final Builder customerArtifactPaths(CustomerArtifactPaths customerArtifactPaths) {
            this.customerArtifactPaths = customerArtifactPaths;
            return this;
        }

        public final void setCustomerArtifactPaths(CustomerArtifactPaths.BuilderImpl customerArtifactPaths) {
            this.customerArtifactPaths = customerArtifactPaths != null ? customerArtifactPaths.build() : null;
        }

        public final Radios.Builder getRadios() {
            return this.radios != null ? this.radios.toBuilder() : null;
        }

        @Override
        public final Builder radios(Radios radios) {
            this.radios = radios;
            return this;
        }

        public final void setRadios(Radios.BuilderImpl radios) {
            this.radios = radios != null ? radios.build() : null;
        }

        public final Collection<String> getAuxiliaryApps() {
            return this.auxiliaryApps;
        }

        @Override
        public final Builder auxiliaryApps(Collection<String> auxiliaryApps) {
            this.auxiliaryApps = AmazonResourceNamesCopier.copy(auxiliaryApps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auxiliaryApps(String ... auxiliaryApps) {
            this.auxiliaryApps(Arrays.asList(auxiliaryApps));
            return this;
        }

        public final void setAuxiliaryApps(Collection<String> auxiliaryApps) {
            this.auxiliaryApps = AmazonResourceNamesCopier.copy(auxiliaryApps);
        }

        public final String getBillingMethod() {
            return this.billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod.toString());
            return this;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        public ScheduleRunConfiguration build() {
            return new ScheduleRunConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScheduleRunConfiguration> {
        public Builder extraDataPackageArn(String var1);

        public Builder networkProfileArn(String var1);

        public Builder locale(String var1);

        public Builder location(Location var1);

        default public Builder location(Consumer<Location.Builder> location) {
            return this.location((Location)((Location.Builder)Location.builder().applyMutation(location)).build());
        }

        public Builder customerArtifactPaths(CustomerArtifactPaths var1);

        default public Builder customerArtifactPaths(Consumer<CustomerArtifactPaths.Builder> customerArtifactPaths) {
            return this.customerArtifactPaths((CustomerArtifactPaths)((CustomerArtifactPaths.Builder)CustomerArtifactPaths.builder().applyMutation(customerArtifactPaths)).build());
        }

        public Builder radios(Radios var1);

        default public Builder radios(Consumer<Radios.Builder> radios) {
            return this.radios((Radios)((Radios.Builder)Radios.builder().applyMutation(radios)).build());
        }

        public Builder auxiliaryApps(Collection<String> var1);

        public Builder auxiliaryApps(String ... var1);

        public Builder billingMethod(String var1);

        public Builder billingMethod(BillingMethod var1);
    }
}

