/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.BillingMethod;
import software.amazon.awssdk.services.devicefarm.model.Counters;
import software.amazon.awssdk.services.devicefarm.model.CustomerArtifactPaths;
import software.amazon.awssdk.services.devicefarm.model.DeviceMinutes;
import software.amazon.awssdk.services.devicefarm.model.DevicePlatform;
import software.amazon.awssdk.services.devicefarm.model.ExecutionResult;
import software.amazon.awssdk.services.devicefarm.model.ExecutionResultCode;
import software.amazon.awssdk.services.devicefarm.model.ExecutionStatus;
import software.amazon.awssdk.services.devicefarm.model.NetworkProfile;
import software.amazon.awssdk.services.devicefarm.model.TestType;
import software.amazon.awssdk.services.devicefarm.transform.RunMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Run
implements StructuredPojo,
ToCopyableBuilder<Builder, Run> {
    private final String arn;
    private final String name;
    private final String type;
    private final String platform;
    private final Instant created;
    private final String status;
    private final String result;
    private final Instant started;
    private final Instant stopped;
    private final Counters counters;
    private final String message;
    private final Integer totalJobs;
    private final Integer completedJobs;
    private final String billingMethod;
    private final DeviceMinutes deviceMinutes;
    private final NetworkProfile networkProfile;
    private final String parsingResultUrl;
    private final String resultCode;
    private final CustomerArtifactPaths customerArtifactPaths;

    private Run(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.platform = builder.platform;
        this.created = builder.created;
        this.status = builder.status;
        this.result = builder.result;
        this.started = builder.started;
        this.stopped = builder.stopped;
        this.counters = builder.counters;
        this.message = builder.message;
        this.totalJobs = builder.totalJobs;
        this.completedJobs = builder.completedJobs;
        this.billingMethod = builder.billingMethod;
        this.deviceMinutes = builder.deviceMinutes;
        this.networkProfile = builder.networkProfile;
        this.parsingResultUrl = builder.parsingResultUrl;
        this.resultCode = builder.resultCode;
        this.customerArtifactPaths = builder.customerArtifactPaths;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public TestType type() {
        return TestType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public DevicePlatform platform() {
        return DevicePlatform.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    public Instant created() {
        return this.created;
    }

    public ExecutionStatus status() {
        return ExecutionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public ExecutionResult result() {
        return ExecutionResult.fromValue(this.result);
    }

    public String resultAsString() {
        return this.result;
    }

    public Instant started() {
        return this.started;
    }

    public Instant stopped() {
        return this.stopped;
    }

    public Counters counters() {
        return this.counters;
    }

    public String message() {
        return this.message;
    }

    public Integer totalJobs() {
        return this.totalJobs;
    }

    public Integer completedJobs() {
        return this.completedJobs;
    }

    public BillingMethod billingMethod() {
        return BillingMethod.fromValue(this.billingMethod);
    }

    public String billingMethodAsString() {
        return this.billingMethod;
    }

    public DeviceMinutes deviceMinutes() {
        return this.deviceMinutes;
    }

    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public String parsingResultUrl() {
        return this.parsingResultUrl;
    }

    public ExecutionResultCode resultCode() {
        return ExecutionResultCode.fromValue(this.resultCode);
    }

    public String resultCodeAsString() {
        return this.resultCode;
    }

    public CustomerArtifactPaths customerArtifactPaths() {
        return this.customerArtifactPaths;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.started());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopped());
        hashCode = 31 * hashCode + Objects.hashCode(this.counters());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.parsingResultUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerArtifactPaths());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Run)) {
            return false;
        }
        Run other = (Run)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.resultAsString(), other.resultAsString()) && Objects.equals(this.started(), other.started()) && Objects.equals(this.stopped(), other.stopped()) && Objects.equals(this.counters(), other.counters()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.totalJobs(), other.totalJobs()) && Objects.equals(this.completedJobs(), other.completedJobs()) && Objects.equals(this.billingMethodAsString(), other.billingMethodAsString()) && Objects.equals(this.deviceMinutes(), other.deviceMinutes()) && Objects.equals(this.networkProfile(), other.networkProfile()) && Objects.equals(this.parsingResultUrl(), other.parsingResultUrl()) && Objects.equals(this.resultCodeAsString(), other.resultCodeAsString()) && Objects.equals(this.customerArtifactPaths(), other.customerArtifactPaths());
    }

    public String toString() {
        return ToString.builder((String)"Run").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Platform", (Object)this.platformAsString()).add("Created", (Object)this.created()).add("Status", (Object)this.statusAsString()).add("Result", (Object)this.resultAsString()).add("Started", (Object)this.started()).add("Stopped", (Object)this.stopped()).add("Counters", (Object)this.counters()).add("Message", (Object)this.message()).add("TotalJobs", (Object)this.totalJobs()).add("CompletedJobs", (Object)this.completedJobs()).add("BillingMethod", (Object)this.billingMethodAsString()).add("DeviceMinutes", (Object)this.deviceMinutes()).add("NetworkProfile", (Object)this.networkProfile()).add("ParsingResultUrl", (Object)this.parsingResultUrl()).add("ResultCode", (Object)this.resultCodeAsString()).add("CustomerArtifactPaths", (Object)this.customerArtifactPaths()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "result": {
                return Optional.ofNullable(clazz.cast(this.resultAsString()));
            }
            case "started": {
                return Optional.ofNullable(clazz.cast(this.started()));
            }
            case "stopped": {
                return Optional.ofNullable(clazz.cast(this.stopped()));
            }
            case "counters": {
                return Optional.ofNullable(clazz.cast(this.counters()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "totalJobs": {
                return Optional.ofNullable(clazz.cast(this.totalJobs()));
            }
            case "completedJobs": {
                return Optional.ofNullable(clazz.cast(this.completedJobs()));
            }
            case "billingMethod": {
                return Optional.ofNullable(clazz.cast(this.billingMethodAsString()));
            }
            case "deviceMinutes": {
                return Optional.ofNullable(clazz.cast(this.deviceMinutes()));
            }
            case "networkProfile": {
                return Optional.ofNullable(clazz.cast(this.networkProfile()));
            }
            case "parsingResultUrl": {
                return Optional.ofNullable(clazz.cast(this.parsingResultUrl()));
            }
            case "resultCode": {
                return Optional.ofNullable(clazz.cast(this.resultCodeAsString()));
            }
            case "customerArtifactPaths": {
                return Optional.ofNullable(clazz.cast(this.customerArtifactPaths()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RunMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String type;
        private String platform;
        private Instant created;
        private String status;
        private String result;
        private Instant started;
        private Instant stopped;
        private Counters counters;
        private String message;
        private Integer totalJobs;
        private Integer completedJobs;
        private String billingMethod;
        private DeviceMinutes deviceMinutes;
        private NetworkProfile networkProfile;
        private String parsingResultUrl;
        private String resultCode;
        private CustomerArtifactPaths customerArtifactPaths;

        private BuilderImpl() {
        }

        private BuilderImpl(Run model) {
            this.arn(model.arn);
            this.name(model.name);
            this.type(model.type);
            this.platform(model.platform);
            this.created(model.created);
            this.status(model.status);
            this.result(model.result);
            this.started(model.started);
            this.stopped(model.stopped);
            this.counters(model.counters);
            this.message(model.message);
            this.totalJobs(model.totalJobs);
            this.completedJobs(model.completedJobs);
            this.billingMethod(model.billingMethod);
            this.deviceMinutes(model.deviceMinutes);
            this.networkProfile(model.networkProfile);
            this.parsingResultUrl(model.parsingResultUrl);
            this.resultCode(model.resultCode);
            this.customerArtifactPaths(model.customerArtifactPaths);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(DevicePlatform platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getResult() {
            return this.result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result.toString());
            return this;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        public final Instant getStarted() {
            return this.started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        public final Instant getStopped() {
            return this.stopped;
        }

        @Override
        public final Builder stopped(Instant stopped) {
            this.stopped = stopped;
            return this;
        }

        public final void setStopped(Instant stopped) {
            this.stopped = stopped;
        }

        public final Counters.Builder getCounters() {
            return this.counters != null ? this.counters.toBuilder() : null;
        }

        @Override
        public final Builder counters(Counters counters) {
            this.counters = counters;
            return this;
        }

        public final void setCounters(Counters.BuilderImpl counters) {
            this.counters = counters != null ? counters.build() : null;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Integer getTotalJobs() {
            return this.totalJobs;
        }

        @Override
        public final Builder totalJobs(Integer totalJobs) {
            this.totalJobs = totalJobs;
            return this;
        }

        public final void setTotalJobs(Integer totalJobs) {
            this.totalJobs = totalJobs;
        }

        public final Integer getCompletedJobs() {
            return this.completedJobs;
        }

        @Override
        public final Builder completedJobs(Integer completedJobs) {
            this.completedJobs = completedJobs;
            return this;
        }

        public final void setCompletedJobs(Integer completedJobs) {
            this.completedJobs = completedJobs;
        }

        public final String getBillingMethod() {
            return this.billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod.toString());
            return this;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        public final DeviceMinutes.Builder getDeviceMinutes() {
            return this.deviceMinutes != null ? this.deviceMinutes.toBuilder() : null;
        }

        @Override
        public final Builder deviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
            return this;
        }

        public final void setDeviceMinutes(DeviceMinutes.BuilderImpl deviceMinutes) {
            this.deviceMinutes = deviceMinutes != null ? deviceMinutes.build() : null;
        }

        public final NetworkProfile.Builder getNetworkProfile() {
            return this.networkProfile != null ? this.networkProfile.toBuilder() : null;
        }

        @Override
        public final Builder networkProfile(NetworkProfile networkProfile) {
            this.networkProfile = networkProfile;
            return this;
        }

        public final void setNetworkProfile(NetworkProfile.BuilderImpl networkProfile) {
            this.networkProfile = networkProfile != null ? networkProfile.build() : null;
        }

        public final String getParsingResultUrl() {
            return this.parsingResultUrl;
        }

        @Override
        public final Builder parsingResultUrl(String parsingResultUrl) {
            this.parsingResultUrl = parsingResultUrl;
            return this;
        }

        public final void setParsingResultUrl(String parsingResultUrl) {
            this.parsingResultUrl = parsingResultUrl;
        }

        public final String getResultCode() {
            return this.resultCode;
        }

        @Override
        public final Builder resultCode(String resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        @Override
        public final Builder resultCode(ExecutionResultCode resultCode) {
            this.resultCode(resultCode.toString());
            return this;
        }

        public final void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        public final CustomerArtifactPaths.Builder getCustomerArtifactPaths() {
            return this.customerArtifactPaths != null ? this.customerArtifactPaths.toBuilder() : null;
        }

        @Override
        public final Builder customerArtifactPaths(CustomerArtifactPaths customerArtifactPaths) {
            this.customerArtifactPaths = customerArtifactPaths;
            return this;
        }

        public final void setCustomerArtifactPaths(CustomerArtifactPaths.BuilderImpl customerArtifactPaths) {
            this.customerArtifactPaths = customerArtifactPaths != null ? customerArtifactPaths.build() : null;
        }

        public Run build() {
            return new Run(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Run> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(TestType var1);

        public Builder platform(String var1);

        public Builder platform(DevicePlatform var1);

        public Builder created(Instant var1);

        public Builder status(String var1);

        public Builder status(ExecutionStatus var1);

        public Builder result(String var1);

        public Builder result(ExecutionResult var1);

        public Builder started(Instant var1);

        public Builder stopped(Instant var1);

        public Builder counters(Counters var1);

        default public Builder counters(Consumer<Counters.Builder> counters) {
            return this.counters((Counters)((Counters.Builder)Counters.builder().applyMutation(counters)).build());
        }

        public Builder message(String var1);

        public Builder totalJobs(Integer var1);

        public Builder completedJobs(Integer var1);

        public Builder billingMethod(String var1);

        public Builder billingMethod(BillingMethod var1);

        public Builder deviceMinutes(DeviceMinutes var1);

        default public Builder deviceMinutes(Consumer<DeviceMinutes.Builder> deviceMinutes) {
            return this.deviceMinutes((DeviceMinutes)((DeviceMinutes.Builder)DeviceMinutes.builder().applyMutation(deviceMinutes)).build());
        }

        public Builder networkProfile(NetworkProfile var1);

        default public Builder networkProfile(Consumer<NetworkProfile.Builder> networkProfile) {
            return this.networkProfile((NetworkProfile)((NetworkProfile.Builder)NetworkProfile.builder().applyMutation(networkProfile)).build());
        }

        public Builder parsingResultUrl(String var1);

        public Builder resultCode(String var1);

        public Builder resultCode(ExecutionResultCode var1);

        public Builder customerArtifactPaths(CustomerArtifactPaths var1);

        default public Builder customerArtifactPaths(Consumer<CustomerArtifactPaths.Builder> customerArtifactPaths) {
            return this.customerArtifactPaths((CustomerArtifactPaths)((CustomerArtifactPaths.Builder)CustomerArtifactPaths.builder().applyMutation(customerArtifactPaths)).build());
        }
    }
}

