/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.CPU;
import software.amazon.awssdk.services.devicefarm.model.DeviceFormFactor;
import software.amazon.awssdk.services.devicefarm.model.DevicePlatform;
import software.amazon.awssdk.services.devicefarm.model.Resolution;
import software.amazon.awssdk.services.devicefarm.transform.DeviceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Device
implements StructuredPojo,
ToCopyableBuilder<Builder, Device> {
    private final String arn;
    private final String name;
    private final String manufacturer;
    private final String model;
    private final String formFactor;
    private final String platform;
    private final String os;
    private final CPU cpu;
    private final Resolution resolution;
    private final Long heapSize;
    private final Long memory;
    private final String image;
    private final String carrier;
    private final String radio;
    private final Boolean remoteAccessEnabled;
    private final Boolean remoteDebugEnabled;
    private final String fleetType;
    private final String fleetName;

    private Device(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.manufacturer = builder.manufacturer;
        this.model = builder.model;
        this.formFactor = builder.formFactor;
        this.platform = builder.platform;
        this.os = builder.os;
        this.cpu = builder.cpu;
        this.resolution = builder.resolution;
        this.heapSize = builder.heapSize;
        this.memory = builder.memory;
        this.image = builder.image;
        this.carrier = builder.carrier;
        this.radio = builder.radio;
        this.remoteAccessEnabled = builder.remoteAccessEnabled;
        this.remoteDebugEnabled = builder.remoteDebugEnabled;
        this.fleetType = builder.fleetType;
        this.fleetName = builder.fleetName;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public String model() {
        return this.model;
    }

    public DeviceFormFactor formFactor() {
        return DeviceFormFactor.fromValue(this.formFactor);
    }

    public String formFactorAsString() {
        return this.formFactor;
    }

    public DevicePlatform platform() {
        return DevicePlatform.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    public String os() {
        return this.os;
    }

    public CPU cpu() {
        return this.cpu;
    }

    public Resolution resolution() {
        return this.resolution;
    }

    public Long heapSize() {
        return this.heapSize;
    }

    public Long memory() {
        return this.memory;
    }

    public String image() {
        return this.image;
    }

    public String carrier() {
        return this.carrier;
    }

    public String radio() {
        return this.radio;
    }

    public Boolean remoteAccessEnabled() {
        return this.remoteAccessEnabled;
    }

    public Boolean remoteDebugEnabled() {
        return this.remoteDebugEnabled;
    }

    public String fleetType() {
        return this.fleetType;
    }

    public String fleetName() {
        return this.fleetName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.manufacturer());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.formFactorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.os());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolution());
        hashCode = 31 * hashCode + Objects.hashCode(this.heapSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.carrier());
        hashCode = 31 * hashCode + Objects.hashCode(this.radio());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteAccessEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDebugEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.manufacturer(), other.manufacturer()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.formFactorAsString(), other.formFactorAsString()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.os(), other.os()) && Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.resolution(), other.resolution()) && Objects.equals(this.heapSize(), other.heapSize()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.carrier(), other.carrier()) && Objects.equals(this.radio(), other.radio()) && Objects.equals(this.remoteAccessEnabled(), other.remoteAccessEnabled()) && Objects.equals(this.remoteDebugEnabled(), other.remoteDebugEnabled()) && Objects.equals(this.fleetType(), other.fleetType()) && Objects.equals(this.fleetName(), other.fleetName());
    }

    public String toString() {
        return ToString.builder((String)"Device").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Manufacturer", (Object)this.manufacturer()).add("Model", (Object)this.model()).add("FormFactor", (Object)this.formFactorAsString()).add("Platform", (Object)this.platformAsString()).add("Os", (Object)this.os()).add("Cpu", (Object)this.cpu()).add("Resolution", (Object)this.resolution()).add("HeapSize", (Object)this.heapSize()).add("Memory", (Object)this.memory()).add("Image", (Object)this.image()).add("Carrier", (Object)this.carrier()).add("Radio", (Object)this.radio()).add("RemoteAccessEnabled", (Object)this.remoteAccessEnabled()).add("RemoteDebugEnabled", (Object)this.remoteDebugEnabled()).add("FleetType", (Object)this.fleetType()).add("FleetName", (Object)this.fleetName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "manufacturer": {
                return Optional.ofNullable(clazz.cast(this.manufacturer()));
            }
            case "model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "formFactor": {
                return Optional.ofNullable(clazz.cast(this.formFactorAsString()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "os": {
                return Optional.ofNullable(clazz.cast(this.os()));
            }
            case "cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "resolution": {
                return Optional.ofNullable(clazz.cast(this.resolution()));
            }
            case "heapSize": {
                return Optional.ofNullable(clazz.cast(this.heapSize()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "carrier": {
                return Optional.ofNullable(clazz.cast(this.carrier()));
            }
            case "radio": {
                return Optional.ofNullable(clazz.cast(this.radio()));
            }
            case "remoteAccessEnabled": {
                return Optional.ofNullable(clazz.cast(this.remoteAccessEnabled()));
            }
            case "remoteDebugEnabled": {
                return Optional.ofNullable(clazz.cast(this.remoteDebugEnabled()));
            }
            case "fleetType": {
                return Optional.ofNullable(clazz.cast(this.fleetType()));
            }
            case "fleetName": {
                return Optional.ofNullable(clazz.cast(this.fleetName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String manufacturer;
        private String model;
        private String formFactor;
        private String platform;
        private String os;
        private CPU cpu;
        private Resolution resolution;
        private Long heapSize;
        private Long memory;
        private String image;
        private String carrier;
        private String radio;
        private Boolean remoteAccessEnabled;
        private Boolean remoteDebugEnabled;
        private String fleetType;
        private String fleetName;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            this.arn(model.arn);
            this.name(model.name);
            this.manufacturer(model.manufacturer);
            this.model(model.model);
            this.formFactor(model.formFactor);
            this.platform(model.platform);
            this.os(model.os);
            this.cpu(model.cpu);
            this.resolution(model.resolution);
            this.heapSize(model.heapSize);
            this.memory(model.memory);
            this.image(model.image);
            this.carrier(model.carrier);
            this.radio(model.radio);
            this.remoteAccessEnabled(model.remoteAccessEnabled);
            this.remoteDebugEnabled(model.remoteDebugEnabled);
            this.fleetType(model.fleetType);
            this.fleetName(model.fleetName);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getManufacturer() {
            return this.manufacturer;
        }

        @Override
        public final Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public final void setManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
        }

        public final String getModel() {
            return this.model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        public final String getFormFactor() {
            return this.formFactor;
        }

        @Override
        public final Builder formFactor(String formFactor) {
            this.formFactor = formFactor;
            return this;
        }

        @Override
        public final Builder formFactor(DeviceFormFactor formFactor) {
            this.formFactor(formFactor.toString());
            return this;
        }

        public final void setFormFactor(String formFactor) {
            this.formFactor = formFactor;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(DevicePlatform platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getOs() {
            return this.os;
        }

        @Override
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        public final CPU.Builder getCpu() {
            return this.cpu != null ? this.cpu.toBuilder() : null;
        }

        @Override
        public final Builder cpu(CPU cpu) {
            this.cpu = cpu;
            return this;
        }

        public final void setCpu(CPU.BuilderImpl cpu) {
            this.cpu = cpu != null ? cpu.build() : null;
        }

        public final Resolution.Builder getResolution() {
            return this.resolution != null ? this.resolution.toBuilder() : null;
        }

        @Override
        public final Builder resolution(Resolution resolution) {
            this.resolution = resolution;
            return this;
        }

        public final void setResolution(Resolution.BuilderImpl resolution) {
            this.resolution = resolution != null ? resolution.build() : null;
        }

        public final Long getHeapSize() {
            return this.heapSize;
        }

        @Override
        public final Builder heapSize(Long heapSize) {
            this.heapSize = heapSize;
            return this;
        }

        public final void setHeapSize(Long heapSize) {
            this.heapSize = heapSize;
        }

        public final Long getMemory() {
            return this.memory;
        }

        @Override
        public final Builder memory(Long memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(Long memory) {
            this.memory = memory;
        }

        public final String getImage() {
            return this.image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final String getCarrier() {
            return this.carrier;
        }

        @Override
        public final Builder carrier(String carrier) {
            this.carrier = carrier;
            return this;
        }

        public final void setCarrier(String carrier) {
            this.carrier = carrier;
        }

        public final String getRadio() {
            return this.radio;
        }

        @Override
        public final Builder radio(String radio) {
            this.radio = radio;
            return this;
        }

        public final void setRadio(String radio) {
            this.radio = radio;
        }

        public final Boolean getRemoteAccessEnabled() {
            return this.remoteAccessEnabled;
        }

        @Override
        public final Builder remoteAccessEnabled(Boolean remoteAccessEnabled) {
            this.remoteAccessEnabled = remoteAccessEnabled;
            return this;
        }

        public final void setRemoteAccessEnabled(Boolean remoteAccessEnabled) {
            this.remoteAccessEnabled = remoteAccessEnabled;
        }

        public final Boolean getRemoteDebugEnabled() {
            return this.remoteDebugEnabled;
        }

        @Override
        public final Builder remoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
            return this;
        }

        public final void setRemoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
        }

        public final String getFleetType() {
            return this.fleetType;
        }

        @Override
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        public final String getFleetName() {
            return this.fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public Device build() {
            return new Device(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Device> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder manufacturer(String var1);

        public Builder model(String var1);

        public Builder formFactor(String var1);

        public Builder formFactor(DeviceFormFactor var1);

        public Builder platform(String var1);

        public Builder platform(DevicePlatform var1);

        public Builder os(String var1);

        public Builder cpu(CPU var1);

        default public Builder cpu(Consumer<CPU.Builder> cpu) {
            return this.cpu((CPU)((CPU.Builder)CPU.builder().applyMutation(cpu)).build());
        }

        public Builder resolution(Resolution var1);

        default public Builder resolution(Consumer<Resolution.Builder> resolution) {
            return this.resolution((Resolution)((Resolution.Builder)Resolution.builder().applyMutation(resolution)).build());
        }

        public Builder heapSize(Long var1);

        public Builder memory(Long var1);

        public Builder image(String var1);

        public Builder carrier(String var1);

        public Builder radio(String var1);

        public Builder remoteAccessEnabled(Boolean var1);

        public Builder remoteDebugEnabled(Boolean var1);

        public Builder fleetType(String var1);

        public Builder fleetName(String var1);
    }
}

